#
# Service to create,check,format and mount App-Host Volume
#
# June 2015, Kishore Karthikeyan
# Copyright (c) 2015-2016 by Cisco Systems, Inc.
# All rights reserved.
#

# Sourcing the Library functions and config files
. /etc/init.d/app_volume_config.conf
. /etc/init.d/calvados_bootstrap.cfg

app_volume_mount()
{
    local disk=$1
    local partition=$2

    run_and_check \
    fdisk -l /dev/$disk$partition

    #
    # Create a seperate physical volume on the carved out partition.
    #
    pvcreate -ff -y /dev/$disk$partition 

    #
    # Creating a seperate volume group, so that it wont interfere with
    # Panini-Vol-Grp of regular operations and during system upgrade.
    #
    run_and_check \
    vgcreate ${TP_LVG} /dev/$disk$partition 

    run_and_check \
    lvcreate -l 100%FREE -n ${TP_LV_NAME} ${TP_LVG} 
    if [[ $? -ne 0 ]]; then
        #
        # Fallback code. Should never be executed as the 100%FREE above
        # should not fail. If we do hit this code then we try successively
        # larger values for DISK_TP_MB_LOST until we get something.
        #

        #
        # Some space is lost due to parititioning and seems to be driver
        # specific. This is the initial guess as to what we need to reserve.
        #
        DISK_TP_MB_LOST=8
        run_and_check \
        lvcreate -L $(( $DISK_TP_VOL_PART_SIZE - $DISK_TP_MB_LOST )) -n ${TP_LV_NAME} ${TP_LVG} 
        if [[ $? -ne 0 ]]; then
            DISK_TP_MB_LOST=200

            run_and_check \
            lvcreate -L $(( $DISK_TP_VOL_PART_SIZE - $DISK_TP_MB_LOST )) -n ${TP_LV_NAME} ${TP_LVG} 
        
            if [[ $? -ne 0 ]]; then
                DISK_TP_MB_LOST=400

                run_and_check \
                lvcreate -L $(( $DISK_TP_VOL_PART_SIZE - $DISK_TP_MB_LOST )) -n ${TP_LV_NAME} ${TP_LVG} 
        
                if [[ $? -ne 0 ]]; then
                    echo
                    echo "*** CRITICAL-ERROR: cannot create app hosting volume ***"
                    echo
                fi
            fi
        fi
    fi

    #
    # Checking the partition, formatting with ext4 FS and labeling it
    #
    run_and_check \
    check_fs_partition "${TP_LV_NAME_FULL}" "AppHost"

    #
    # Create a App-Hosting directory in Host to be mounted inside XR
    #
    run_and_check \
    mkdir -p ${TP_LV_DIR_PATH}

    #
    # Mount the created TP logical volume on the App-Host directory
    #
    run_and_check \
    mount ${TP_LV_NAME_FULL} ${TP_LV_DIR_PATH} 
}
