#!/bin/sh
# 
# load all the kernel modules  in order same as nxos rcS.d level
# Copyright (c) 2015-2016, 2018, 2020-2021 by Cisco Systems, Inc.
# All rights reserved.

MOD_PATH=/etc/init.d/mod_ins

install=$(cat /proc/cmdline | grep install=)
if [ -z "${install}" ]; then
    . /etc/init.d/mod_ins/module-load-functions
fi

load_all_rplc_kernel_module() {
    boot_debug "Calling S00mts.."
    $MOD_PATH/S00mts start

    boot_debug "Calling S00i2c-dev.."
    $MOD_PATH/S00i2c-dev start

    boot_debug "Calling S01procfs-init.."
    $MOD_PATH/S01procfs-init start

    boot_debug "Calling S02make-devices.."
    $MOD_PATH/S02make-devices start

    boot_debug "Calling S03cmos.."
    $MOD_PATH/S03cmos start

    boot_debug "Calling S04install-igb.."
    $MOD_PATH/S04install-igb start

    boot_debug "Calling S09setup-eth to set intr affinity.."
    #doing this in the back ground here will save time
    $MOD_PATH/S09setup-eth  pre_init &
    local PID_ETH_PRE_INIT=$!

    boot_debug "Calling S05instsse.."
    $MOD_PATH/S05instsse start

    boot_debug "Calling S05itlv.."
    $MOD_PATH/S05itlv start

    boot_debug "Calling S05mount_debugfs.."
    $MOD_PATH/S05mount_debugfs start

    boot_debug "Calling S05sdwrap.."
    $MOD_PATH/S05sdwrap start

    boot_debug "Calling S06install-cctrl.."
    $MOD_PATH/S06install-cctrl start

    boot_debug "Calling S07install-u-dma-buf.."
    $MOD_PATH/S07install-u-dma-buf start

    boot_debug "Calling S08setup-sprom .."
    $MOD_PATH/S08setup-sprom  start &
    PID_SPROM=$!

    boot_debug "Calling S07check_ssd .."
    $MOD_PATH/S07check_ssd  start

    boot_debug "Calling S07configure_kernel .."
    $MOD_PATH/S07configure_kernel  start

    boot_debug "Calling S08check-flash-noinit .."
    $MOD_PATH/S08check-flash-noinit  start

    wait ${PID_SPROM}

    boot_debug "Calling S09nvram .."
    $MOD_PATH/S09nvram  start

    boot_debug "Calling S36mvdxn .."
    $MOD_PATH/S36mvdxn  start

    wait $PID_ETH_PRE_INIT
    boot_debug "Calling S09setup-eth .."
    $MOD_PATH/S09setup-eth  start

    boot_debug "Calling S12install-obfl .."
    $MOD_PATH/S12install-obfl  start

    if [ "$boardtype" = "LC" ]; then
        boot_debug "Calling S51install-emon-lc.."
        $MOD_PATH/S51install-emon-lc start
    else
        boot_debug "Calling S41install-emon.."
        $MOD_PATH/S41install-emon start
    fi

    if [ "$boardtype" = "LC" ]; then

        KERNEL_BDE_OPTIONS="reverse_enum_dev_total=0 debug=2 dmasize=64M usemsi=1"
        modprobe linux-kernel-bde $KERNEL_BDE_OPTIONS
        modprobe linux-user-bde
        /bin/mknod /dev/linux-kernel-bde c 127 0
        /bin/mknod /dev/linux-user-bde c 126 0
        modprobe linux-bcm-knet rcpu_signature=0x8690 use_napi=1 use_rx_skb=1 rx_rate=400000,400000,400000,400000 default_mtu=9400 rx_buffer_size=9728 
        /bin/mknod /dev/linux-bcm-knet c 122 0
    fi
    if [ "$boardtype" = "LC" ]; then
        boot_debug "Calling S52install-db-iofpga.."
        $MOD_PATH/S52install-db-iofpga
    fi
    if [ "$boardtype" = "LC" ]; then
        boot_debug "Calling S42klmkbp.."
        $MOD_PATH/S42klmkbp start
    fi
    if [ "$boardtype" = "LC" ]; then
        boot_debug "Calling S52install-uio-aldrin.."
        $MOD_PATH/S52install-uio-aldrin
    fi


}

load_all_fcxc_kernel_module() {
    boot_debug "Calling S00mts.."
    $MOD_PATH/S00mts start

    boot_debug "Calling S00i2c-dev.."
    $MOD_PATH/S00i2c-dev start

    boot_debug "Calling S01procfs-init.."
    $MOD_PATH/S01procfs-init start

    #Augustus-4 is Intel based and n/w driver for x86_64 bzImage is not compiled statically
    declare -F pd_is_augustus_arm_processor && pd_is_augustus_arm_processor
    if [ "$?" -ne 0 ]; then
        boot_debug "FC card is Intel based...."
        boot_debug "Calling S04install-igb.."
        $MOD_PATH/S04install-igb start
    fi

    boot_debug "Calling S05instsse.."
    $MOD_PATH/S05instsse start

    boot_debug "Calling S05itlv.."
    $MOD_PATH/S05itlv start

    boot_debug "Calling S05sdwrap.."
    $MOD_PATH/S05sdwrap start

    boot_debug "Calling S06install-cctrl.."
    $MOD_PATH/S06install-cctrl start

    # load klm_nvram.ko and klm_dc_sprom.ko KLMs in case of
    # Augustus-4 x86 based card.
    declare -F pd_is_augustus_arm_processor && pd_is_augustus_arm_processor
    if [ "$?" -ne 0 ]; then
        boot_debug "Calling S08setup-sprom .."
        $MOD_PATH/S08setup-sprom  start &
        PID_SPROM=$!

        wait ${PID_SPROM}

        boot_debug "Calling S09nvram .."
        $MOD_PATH/S09nvram  start
    fi

    boot_debug "Calling S12install-obfl .."
    $MOD_PATH/S12install-obfl  start
   
    if [ "$boardtype" = "XC" ]; then
        boot_debug "Calling S36mvdxn.."
        $MOD_PATH/S36mvdxn start

        boot_debug "Calling S40klmesd.."
        $MOD_PATH/S40klmesd start
    else
        # S44klmfabric needs to be started before S36mvdxn on the FCs. 
        # This is required because the Uluru16 CE switch is on
        # power domain 2, which gets enabled by S44klmfabric.
        boot_debug "Calling S44klmfabric.."
        $MOD_PATH/S44klmfabric start

        boot_debug "Calling S36mvdxn.."
        $MOD_PATH/S36mvdxn start
    fi
    
    boot_debug "Calling S09setup-eth.."
    $MOD_PATH/S09setup-eth start

    declare -F pd_is_augustus_arm_processor && pd_is_augustus_arm_processor
    if [ "$?" -ne 0 ]; then
        boot_debug "Calling S51install-emon.."
        $MOD_PATH/S51install-emon-lc start
    else
        boot_debug "Calling S41install-emon.."
        $MOD_PATH/S41install-emon start
    fi

# Uncomment this code snippet to enable eUSB on FC
#    if [ "$boardtype" = "FC" ]; then
#        HW_CHANGE_BITS=`idprom_host_utility -a arm | grep HW_CHANGE_BITS | cut -d ':' -f2`
#        HAS_USB_DEVICE=$(($HW_CHANGE_BITS & 1))
#        if [ "$HAS_USB_DEVICE" -eq 1 ]; then
#            boot_debug "Calling S45eusb-load-ehci-hcd.."
#            $MOD_PATH/S45eusb-load-ehci-hcd start
#        fi
#    fi

}

load_all_kernel_module() {
    boardtype=$(get_cctrl_board_type)

    if [ "$boardtype" = "FC" ] || [ "$boardtype" = "XC" ]; then
        if [ -f /etc/init.d/spirit_pd.sh ]; then
            source /etc/init.d/spirit_pd.sh
        fi
        load_all_fcxc_kernel_module;
    else
        load_all_rplc_kernel_module;
    fi
}

#load_all_kernel_module
