#!/bin/bash
#
# calvados/zermatt_pkg/boot/scripts/cpu_intr_mask.sh
# This script provides functionality to mask the interrupt
# CPU_ERROR_0/1/2.
#
# Copyright (c) 2021 by Cisco Systems, Inc.
# All rights reserved.

# source PD-function library

if [ -f /etc/rc.d/init.d/pd-functions ]; then
    source /etc/rc.d/init.d/pd-functions
fi

function cpu_error_intr_mask ()
{
    case $1 in
    1)
         # Mask CPU_ERROR_2
         platform_log "CPU_ERROR_2 is received intr:$1"
         intr_byte_to_read=$(setpci -s 0:5.2 0xA4.B)
         intr_byte_to_read="0x$intr_byte_to_read"
         platform_log "INTR BIT read $intr_byte_to_read"
         byte_to_mask_err_2=$((intr_byte_to_read&=0xCF))
         byte_to_mask_err_2=`printf '%x\n' $byte_to_mask_err_2`
         byte_to_mask_err_2="0x$byte_to_mask_err_2"
         platform_log "INTR BIT to set $byte_to_mask_err_2"
         setpci -s 00:05.2 A4.B=$byte_to_mask_err_2
         lspci -vvv -nn >> /misc/disk1/cpu_error2_intr.log
         lspci -s0:5.2 -vvv -nn -xxxx >> /misc/disk1/cpu_error2_intr.log
         ;;
    2)
         # Mask CPU_ERROR_1
         platform_log "CPU_ERROR_1 is received intr:$1"
         intr_byte_to_read=$(setpci -s 0:5.2 0xA4.B)
         intr_byte_to_read="0x$intr_byte_to_read"
         platform_log "INTR BIT read $intr_byte_to_read"
         byte_to_mask_err_1=$((intr_byte_to_read&=0xF3))
         byte_to_mask_err_1=`printf '%x\n' $byte_to_mask_err_1`
         byte_to_mask_err_1="0x$byte_to_mask_err_1"
         platform_log "INTR BIT to set $byte_to_mask_err_1"
         setpci -s 00:05.2 A4.B=$byte_to_mask_err_1
         lspci -vvv -nn >> /misc/disk1/cpu_error1_intr.log
         lspci -s0:5.2 -vvv -nn -xxxx >> /misc/disk1/cpu_error1_intr.log
         ;;
    4)
         # Mask CPU_ERROR_0
         platform_log "CPU_ERROR_0 is received intr:$1"
         intr_byte_to_read=$(setpci -s 0:5.2 0xA4.B)
         intr_byte_to_read="0x$intr_byte_to_read"
         platform_log "INTR BIT read $intr_byte_to_read"
         byte_to_mask_err_0=$((intr_byte_to_read&=0xFC))
         byte_to_mask_err_0=`printf '%x\n' $byte_to_mask_err_0`
         byte_to_mask_err_0="0x$byte_to_mask_err_0"
         platform_log "INTR BIT to set $byte_to_mask_err_0"
         setpci -s 00:05.2 A4.B=$byte_to_mask_err_0
         lspci -vvv -nn >> /misc/disk1/cpu_error0_intr.log
         lspci -s0:5.2 -vvv -nn -xxxx >> /misc/disk1/cpu_error0_intr.log
         ;;
    *)
         platform_log "Unknown Interrupt, no action.";
         ;;
    esac

}

cpu_error_intr_mask "$1"
