#!/bin/sh
# 
# load all the kernel modules  in order same as nxos rcS.d level
# Copyright (c) 2015-2016, 2020 by Cisco Systems, Inc.
# All rights reserved.

MOD_PATH=/etc/init.d/mod_ins

install=$(cat /proc/cmdline | grep install=)

if [ -z "${install}" ]; then
    . /etc/init.d/mod_ins/module-load-functions
fi

load_all_kernel_module() {
    boot_debug "Calling S01procfs-init.."
    $MOD_PATH/S01procfs-init start

    boot_debug "Calling S02make-devices.."
    $MOD_PATH/S02make-devices start

    boot_debug "Calling S03cmos.."
    $MOD_PATH/S03cmos start

    boot_debug "Calling S05instsse.."
    $MOD_PATH/S05instsse start

    boot_debug "Calling S05itlv.."
    $MOD_PATH/S05itlv start

    boot_debug "Calling S05mount_debugfs.."
    $MOD_PATH/S05mount_debugfs start

    boot_debug "Calling S05sdwrap.."
    $MOD_PATH/S05sdwrap start

    boot_debug "Calling S07check_ssd .."
    $MOD_PATH/S07check_ssd  start

    boot_debug "Calling S07configure_kernel .."
    $MOD_PATH/S07configure_kernel  start

    boot_debug "Calling S08check-flash-noinit .."
    $MOD_PATH/S08check-flash-noinit  start

    boot_debug "Calling S36mvdxn .."
    $MOD_PATH/S36mvdxn  start

    boot_debug "Calling S09nvram.."
    $MOD_PATH/S09nvram start

    boot_debug "Create the nvram device node.."
    mknod /dev/nvram c 242 0

    boot_debug "Calling S12install-obfl .."
    $MOD_PATH/S12install-obfl  start

    boot_debug "Calling S44klmfabric.."
    $MOD_PATH/S44klmfabric start

    boot_debug "Calling S42klmkbp.."
    $MOD_PATH/S42klmkbp start

    boot_debug "Calling S04install-igb.."
    $MOD_PATH/S04install-igb start
}

