#!/bin/bash
#
# calvados/fretta_pkg/boot/scripts/fretta/pass-dma-dev-lxc.sh
#
# This script has STATS FPGA specific functions which passes the 
# DMA devices to the LC XR LXC
#
# Rahul Mathur
# 
# Ref : Dev-allow, devlist
#
# Copyright (c) 2017-2018, 2020-2021 by Cisco Systems, Inc.
# All rights reserved.
#

# Caller of this script is from the udev rules 
# Udev caller path: calvados/fretta_pkg/boot/scripts/fretta/stats-fpga.rules 

source /etc/rc.d/init.d/mod_ins/module-load-functions
source /etc/init.d/spirit_pd.sh

DMA_PATH_DEV="/dev/"
VIRSH_CMD_FIXED="virsh attach-device default-sdr--2"
VIRSH_CMD_MOD="virsh attach-device default-sdr--1"
# Description: This function does the following 
# 1. Take the dma device name
# 2. It will then create an absolute path for DMA device e.g: /dev/xdma0_c2h_**
# 3. It will then create a small XML and add the device in #3 to the XML 
# 4. It will then dynamically add the device from the LC XR LXC
create_xml_add_to_virsh(){
   local  dma_dev_path_abs
   local  fpga_id
   local  virsh_cmd
   init_iofpga_base_addr

   dma_dev_path_abs="$DMA_PATH_DEV$1"
   xml_path="/tmp/$1_add_tmp.xml"
   
   boot_debug "Abs path for dma $dma_dev_path_abs"

   echo '<hostdev mode="capabilities" type="misc"><source><char>'"$dma_dev_path_abs"'</char></source></hostdev>' > $xml_path

   fpga_id=$(iofpga_reg_read 0x4)

   # For modular LC card like Potenza MPA LC's we would do SDR1 and not SDR2 
   case "$fpga_id" in 
       0x0150532D) # LC POTENZA+MPA TCAM
           virsh_cmd=$VIRSH_CMD_MOD
           ;;
       0xA0171FD3) # Peyto 
           virsh_cmd=$VIRSH_CMD_FIXED
           ;;
       0x90744254) # Eyrie
           virsh_cmd=$VIRSH_CMD_MOD
           ;;
       0x80744254)
           virsh_cmd=$VIRSH_CMD_MOD
           ;;
       0x01601008) # VIGOR MOD LC
           virsh_cmd=$VIRSH_CMD_MOD
           ;;
       *)
           virsh_cmd=$VIRSH_CMD_FIXED
   esac
   
   boot_debug "virsh cmd for dma add: $virsh_cmd $xml_path dma_path=$dma_dev_path_abs"
   $virsh_cmd $xml_path
   rm $xml_path
}


boot_debug "Running pass-dma-dev-lxc.sh"

boot_debug "Got $1 from klm_stats_fpga for addition"
create_xml_add_to_virsh $1


