#!/bin/bash 
if [ $HOSTNAME == "host" ]; then

    /etc/init.d/wboot_reset_state.pl status
    VAL=$?

    if [ -f "/tmp/coldboot" ] || [ _$VAL == _0 ] ; then
            echo "Warmboot disabled"
            touch /tmp/coldboot
            echo "Unloading older kernel "
            /usr/sbin/kexec -u
            /etc/init.d/wboot_reset_state.pl disable

    elif  [ _$VAL != _0 ]; then

        echo "Warmboot enabled"
        [ ! -d  /tmp/efi_part ] &&  mkdir /tmp/efi_part && mount  /dev/ieusb4 /tmp/efi_part
        NXT_PART=$(grep "root=" /tmp/efi_part/EFI/Cisco/grub.cfg  | awk -F "root=" ' { print $2 }' | awk ' { print $1 }')
        CUR_PART=$( cat /proc/cmdline | awk -F "root=" ' { print $2 }' | awk ' { print $1 }')

        echo "Current     Partition=$CUR_PART\n"
        echo "Programmed  Partition=$NXT_PART\n"

        if [ "$CUR_PART" != "$NXT_PART" ]; then
            echo "Upgrade Case"
            ROOT_PART=/tmp/v2_part
            echo "Mounting $NXT_PART"
            [ ! -d $ROOT_PART ] && mkdir  $ROOT_PART
            umount $ROOT_PART
            mount $NXT_PART  $ROOT_PART

            echo "Unloading older Kernel"
            echo /usr/sbin/kexec -u

            KERN_ARGS=$( grep root=  /tmp/efi_part/EFI/Cisco/grub.cfg  | sed -e s/"linux "//  -e s/"\/boot\/bzImage "//)

            echo "Loading new Kernel with args"
     	    /usr/sbin/kexec -l $ROOT_PART/boot/bzImage  --initrd=$ROOT_PART/boot/initrd.img --command-line="$KERN_ARGS"
       fi
    fi
fi
