#!/bin/bash
#
# calvados_hushd.sh
# Script having bash functions for hushd C
# function to create/update calvados_launch_path.txt
# and calvados_launch_path_active.txt
#
# Copyright (c) 2019 by cisco Systems, Inc.
# All rights reserved.

function create_calvados_bootpath_file {
    set -e
    local file_to_write=${1}

    if [ ! "${1}" ]; then
    {
        /usr/bin/logger -i ${FUNCNAME[0]} "No file to write to, returning"
        return
    }
    fi

    local bootpath=/dev/panini_vol_grp/${2}

    local datalv=${3}
    local delim=""
    local datapath=""
    if [ "${datalv}" ]; then
    {
        delim=":"
        datapath=/dev/panini_vol_grp/${3}
    }
    fi

    local fullstring=$bootpath$delim$datapath
    echo $fullstring > $file_to_write

    sync
    sleep 5

    /usr/bin/logger -i ${FUNCNAME[0]} "Content written: " $fullstring
    /usr/bin/logger -i ${FUNCNAME[0]} "To file: " $file_to_write
    /usr/bin/logger -i ${FUNCNAME[0]} "Content read from " $file_to_write
    cat $file_to_write | /usr/bin/logger

    set +e
}

