#!/bin/bash
#
# calvados_launch_sim.sh
#
# Copyright (c) 2014-2015 by Cisco Systems, Inc.
# All rights reserved.

# File structure
# calvados_launch.sh
#   calvados_launch_pd.sh
#     calvados_launch_sim.sh
#       calvados_launch_common.sh

function cal_sim_build_os_kvm_xml {
cat << end_build_os_kvm_xml >> $OUT_XML_FILE
  <os>
    <type arch='x86_64' machine='pc-q35-1.5'>hvm</type>
  </os>
end_build_os_kvm_xml
}

#build interface
function cal_sim_build_interface_xml {
    #simulation
    /sbin/ifconfig eth1 &> /dev/null
    if [ "$?" -eq 0 ] ; then
        declare -F platform_log &>/dev/null && platform_log \
            "*INFO* Found eth1 "
        /sbin/ifconfig  eth1 | grep eth1 |  awk '{print $5}'> /tmp/eth1_mac
    else
        /sbin/ifconfig eth-vf1 &> /dev/null 2>&1
        if [ "$?" -eq 0 ] ; then
            declare -F platform_log &>/dev/null && platform_log \
                "*INFO* Found eth1 "
            /sbin/ifconfig eth-vf1 | grep eth-vf1 | awk '{print $5}'> /tmp/eth1_mac
        else
            declare -F platform_log &>/dev/null && platform_log \
                "$FUNCNAME: *ERROR* no eth1 or eth-vf1 is there bailing"
            exit 1
        fi
    fi

    cat /tmp/eth1_mac | awk '{split($0,array,":")} END {print "92:01:00:" array[4] ":" array[5] ":" array[6] }' > /tmp/calvados_mac_vlan0
    cat /tmp/eth1_mac | awk '{split($0,array,":")} END {print "92:01:01:" array[4] ":" array[5] ":" array[6] }' > /tmp/calvados_mac_vlan1

    #SIM_ETH1_ARGS="-net nic,macaddr=`cat /tmp/calvados_mac_vlan1`,model=virtio,vlan=1 -net tap,vlan=1,ifname=ce_tap_calv"
    MAC_VLAN0=`cat /tmp/calvados_mac_vlan0`
    MAC_VLAN1=`cat /tmp/calvados_mac_vlan1`

cat << end_build_interface_xml >> $OUT_XML_FILE
    <interface type='user'>
      <mac address='$MAC_VLAN0'/>
      <model type='virtio'/>
    </interface>
    <interface type='ethernet'>
      <mac address='$MAC_VLAN1'/>
      <target dev='ce_tap_calv'/>
      <model type='virtio'/>
    </interface>
end_build_interface_xml
}

#setup simluation proxy
function cal_sim_build_proxy_devices_xml {
     
    #get the qemu command line
    /usr/bin/lspci_scan.sh
     
    #translate qemu command line to xml 
    OLDIFS="$IFS"
    IFS=' ' read -a array <<< `cat /opt/simulation/vxr.devs.calv`
    IFS="$OLDIFS"

    index=0
    while [[ $index -lt ${#array[@]} ]];
    do
        #echo "$index ${array[$index]}"
        OPTION=${array[$index]}
        ((index = index + 1))
        OPTION_ARG=${array[$index]}
        ((index = index + 1))
        echo "$OPTION" 
        echo "$OPTION_ARG"
        cal_cmn_build_arg_xml
    done
}

#setup connection redirect
function cal_sim_build_connect_redirect_xml {
    OPTION="-redir"
    OPTION_ARG="tcp:50003::22"
    cal_cmn_build_arg_xml

    OPTION_ARG="tcp:12159::2159"
    cal_cmn_build_arg_xml
}


#create the config file in xml format 
function cal_sim_build_xml {
    declare -F platform_log &>/dev/null && platform_log \
        "$FUNCNAME: simulator mode"

    if [ -z "$VIRT_MEM" ]; then
        VIRT_MEM=2097152
    fi
    VIRT_SMP=1
    cal_cmn_build_virt_base_cfg_xml #build the basic piece for virtualization 
    
    cal_sim_build_os_kvm_xml
    cal_cmn_build_devices_start_xml #start device tag

    VIRT_EMULATOR="/usr/bin/vspirit-kvm-qemu-system-x86_64"
    cal_cmn_build_emulator_xml

    cal_cmn_build_block_devices_xml #build disk device

    cal_cmn_build_usb_xml
    CONSOLE_IPADDR="10.0.2.15" #get it from config file
    cal_sim_build_interface_xml
    cal_cmn_build_console_access_xml
    cal_cmn_build_devices_end_xml

    cal_cmn_build_cmdline_start_xml
    cal_cmn_build_common_args_xml
    cal_sim_build_proxy_devices_xml
    cal_sim_build_connect_redirect_xml

    cal_cmn_build_cmdline_end_xml
    cal_cmn_build_domain_end_xml
}

