#!/bin/bash
#
# Every 5 minutes crontab runs this file
# Keep the disk clean. Remove large files
#

#usage <THIS-SCRIPT> /var/log NN

# Mounted volume to be monitored.
MOUNT="$1"
# Maximum threshold of volume used as an integer that represents a percentage:
# 95 = 95%.
MAX_USAGE="$2"

check_capacity () {
    USAGE=`df -hP $MOUNT | grep -v "Use" | awk '{ print $5 }' | sed s/%//g`

    if [ ! "$?" == "0" ]
    then
        echo "Error: mountpoint $MOUNT not found in df output."
        exit 1
    fi
    if [ "$USAGE" -gt "$MAX_USAGE" ]; then
        return 0
    else
        return 1
    fi
}

CYCLES=0
MAX_CYCLES=5

while check_capacity
do
    #Only allow to loop through 5 times
    if [ "$CYCLES" -gt "$MAX_CYCLES" ]; then
       exit 1  
    fi
    
    FILES=`find ${MOUNT} -name ".copy_cores" -prune -o -name "obfl" -prune -o -type f -printf "%s\t%p\n" | sort -nr |\
           awk '{ print $2 }' | head -n 10`
    IFS=$'\n'

    # if .copy_cores existed, use it as time reference
    # truncate files with timestamp earlier than .copy_cores
    # .copy_cores is currently used in XR background copy but not in Calvados 
    if [ -f $MOUNT/core/.copy_cores ];
    then
        file1time=`stat -c %Y  $MOUNT/core/.copy_cores`
    fi

    for x in $FILES; do
        # check whether the file is being accessed by any processes
        # If not in use, will try to truncate it.
        fuser $x
        if [ $? -ne 0 ];
        then
            # File not in use
            # if .copy_cores exist, files to be truncated will be checked against 
            # if .copy_cores does not exist, go ahead to truncate it
            if [ -f $MOUNT/core/.copy_cores ];
            then
                file2time=`stat -c %Y $x`
                if [ $file1time -gt $file2time ];
                then
                    echo "Truncated by /usr/bin/filecleanup.sh" > $x
                fi
            else
                echo "TRUNCATED by /usr/bin/filecleanup.sh" > $x
            fi
        fi
    done
    ((CYCLES++))
done
