# -*-Shell-script-*-
#
# Author : Mahesh Singh
#
# this script has following functions.
#
## mount_pd_fs: it bind mounts all the FS listed in /etc/init.d/fs_required.txt
##              to $1
#
## mount_efi_and_proc: it bind mounts /proc and EFI/boot partition to $1
#
## umount_pd_fs: it unmounts all the FS from $1 listed in /etc/init.d/fs_required.txt
#
## umount_efi_and_proc: it unmounts EFI/boot and /proc from $1
#
# Copyright (c) 2016-2017, 2020 by Cisco Systems, Inc.
# All rights reserved.
#

COMPRESSED_INITRD_VER=1.2
CHROOT_SUPPORT_VER=1.1
PKG_VER=1.0
ISO_INFO_FILE="iso_info.txt"

function mount_pd_fs {
    set -o nounset
    set -o errexit

    installed_dir=${1}
    file_to_read="/etc/init.d/fs_required.txt"
    files_to_read=${installed_dir}/${file_to_read}
    if [ -f "${files_to_read}" ];then
        while IFS='' read -r line || [[ -n "$line" ]]; do
            mkdir -p $installed_dir/$line
            if [ -d $line ]; then
                mount -o bind $line $installed_dir/$line
            fi 
            #mount -o remount,ro,bind $line $installed_dir/$line
        done < "${files_to_read}" 
    fi

    set +o nounset
    set +o errexit

}

function umount_pd_fs {
    set -o nounset
    set +e

    installed_dir=${1}
    file_to_read="/etc/init.d/fs_required.txt"
    files_to_read=${installed_dir}/${file_to_read}

    if [ -f "${files_to_read}" ];then
        while IFS='' read -r line || [[ -n "$line" ]]; do
            if [ -d $installed_dir/$line ]; then
                umount -l $installed_dir/$line
            fi
        done < "${files_to_read}" 
    fi
    set +o nounset
}

function mount_efi_and_proc {
    installed_dir=${1}
    efi_partition_dir=${2}

    set -o errexit
    if [ ! -z $efi_partition_dir ]; then
        mkdir -p ${installed_dir}/${efi_partition_dir}
        mount -o bind ${efi_partition_dir} ${installed_dir}/${efi_partition_dir}
    fi
    mkdir -p ${installed_dir}/proc
    mount -o bind /proc ${installed_dir}/proc   
    #mount -o remount,ro,bind /proc ${installed_dir}/proc  
    set +e
}

function umount_efi_and_proc {
    installed_dir=${1}
    efi_partition_dir=${2}

    set -o errexit
    if [ ! -z $efi_partition_dir ]; then
        umount -l ${installed_dir}/${efi_partition_dir}
    fi
    umount -l ${installed_dir}/proc
    set +o errexit
}

function compare_versions {
    set -o nounset
    local version1=${1}
    local version2=${2}
    local diff=0

    IFS='.' read -ra arr1 <<< "${version1}"

    IFS='.' read -ra arr2 <<< "${version2}"

    for ((i=0;i<${#arr1[@]};++i)); do
        if [ ${arr1[i]} != ${arr2[i]} ] ; then
            let "diff = ${arr1[i]} - ${arr2[i]}" 
            break    
        fi    
    done
    set +o nounset
    echo "${diff}"
}

function check_chroot_support {
    set -o nounset
    local iso_mnt=${1}
    local diff=0

    IsoType=$(check_iso_type ${iso_mnt})
    if [ -n "${IsoType}" ]; then
        diff=$(compare_versions "${IsoType}" "${CHROOT_SUPPORT_VER}")
        if [[ $diff -ge 0 ]]; then
            echo "yes"
        else
            echo "no"
        fi
    else
       echo "no" 
    fi

    set +o nounset
}
function check_exr_support {
    set -o nounset
    local iso_mnt=${1}
    local diff=0

    IsoType=$(check_iso_type ${iso_mnt})
    if [ -n "${IsoType}" ]; then
        diff=$(compare_versions "${IsoType}" "${PKG_VER}")
        if [[ $diff -ge 0 ]]; then
            echo "yes"
        else
            echo "no"
        fi
    else
       echo "no" 
    fi

    set +o nounset
}
function check_iso_type {
    local iso_mnt=${1}
    local iso_file=${iso_mnt}/${ISO_INFO_FILE}
    local pkg_format_chg=0.0

    if [ -f ${iso_file} ]; then
       pkg_format_chg=`awk -F" "  '/PKG_FORMAT_VER:/{print $2}' ${iso_file}`
    fi
    echo "${pkg_format_chg}"
}

function check_optimised_iso_support {
    set -o nounset
    local iso_mnt=${1}
    local diff=0

    IsoType=$(check_iso_type ${iso_mnt})
    if [ -n "${IsoType}" ]; then
        diff=$(compare_versions "${IsoType}" "${COMPRESSED_INITRD_VER}")
        if [[ $diff -ge 0 ]]; then
            echo "yes"
        else
            echo "no"
        fi
    else
       echo "no" 
    fi

    set +o nounset
}
