# -*-Shell-script-*-
#
# Author : Mahesh Singh
#
# this script has functions for grub.cfg/menu.lst updation.
# Copyright (c) 2017-2021 by Cisco Systems, Inc.
# All rights reserved.
#
source /etc/init.d/calvados_bootstrap.cfg

function pi_update_menu_lst_boot {
    local boottype=${1}
    local grubdir=${2}
    local partmnt=${3}
    local is_pxe_boot=${4}
    local host_lv_name_full=/dev/${5}
    local platform=${6}
    local boot_dev=${7}
    local boardtype=${8}
    local is_sim=${9}
    if [ "$platform" != "xboard" -o "$boottype" == "legacy" ]; then
      if ! test -e ${grubdir}/grub.conf ; then
          test -e ${grubdir}/menu.lst && ln -s ./menu.lst ${grubdir}/grub.conf
      fi
      # before all invocations of the grub shell, call sync to make sure
      # the raw device is in sync with any bufferring in filesystems.
      sync
  
    if [ "${is_pxe_boot}" = "1" ];then 
    # now perform the  grubinstallation.
    $grub_shell --batch $no_floppy --device-map=/dev/null <<eof >&107 2>&1
device (hd0) ${dev}
root (hd0,0)
setup $force_lba (hd0)
quit
eof
    else 
        #this is SU scenario.we need to copy some additional files to vda1/sda1
        boot_dir="${grubdir}/../../boot/"
        if [ -d "${boot_dir}" ]; then
            #back up initrd and bzImage
            if [ ! -e /misc/config/bzImage ]; then
                cp ${boot_dir}/bzImage    /misc/config/
            fi
            if [ ! -e /misc/config/initrd.img ]; then
                cp ${boot_dir}/initrd.img /misc/config/
            fi
            cp ${partmnt}/boot/bzImage "${boot_dir}"/
            cp ${partmnt}/boot/initrd.img "${boot_dir}"/
        fi
        echo "copy of bzImage and initrd to boot_dev is done"
    fi
    fi
    #fix menu.lst script
    if [ "$platform" == "xboard" ]; then
        echo "using xboard based menu.lst"
        cp ${grubdir}/menu.lst.xboard ${grubdir}/menu.lst
    fi
    declare -f pd_pxe_set_menu_lst &>/dev/null && pd_pxe_set_menu_lst
    if [ -z "$grub_part" ]; then
        sed -i -e "s;root (cd); root (hd0,0);" ${grubdir}/menu.lst
    else
        sed -i -e "s;root (cd); root (hd0,$grub_part);" ${grubdir}/menu.lst
    fi
    if [ "$platform" == "xboard" ]; then
        sed -i -e "s;root=/dev/ram;root=${dev}${device_part} platform=xboard boardtype=${boardtype} vmtype=hostos;" ${grubdir}/menu.lst
    else
        sed -i -e "s;root=/dev/ram;root=${boot_dev} boardtype=${boardtype} vmtype=hostos;" ${grubdir}/menu.lst
    fi

    if [ -b /dev/vda1 ]; then
        if [ ! -z ${is_sim} ];then
            if [[ "${is_sim}" != 0 ]]; then
                sed -i -ie "s;root=/dev/vda1;root=${host_lv_name_full} __vxr=true platform=${platform};" ${grubdir}/menu.lst
                if [ "$boardtype" == "LC" ]; then
                    sed -i -e "s;\bbigphysarea=[0-9]*M\b;&\;4616M;" ${grubdir}/menu.lst
                fi
            else 
                sed -i -ie "s;root=/dev/vda1;root=${host_lv_name_full} ;" ${grubdir}/menu.lst
            fi
        else
            sed -i -ie "s;root=/dev/vda1;root=${host_lv_name_full} ;" ${grubdir}/menu.lst
        fi
    elif [ -b /dev/nvme0n1 ]; then
        sed -i -ie "s;root=/dev/nvme0n1;root=${host_lv_name_full};" ${grubdir}/menu.lst
    else
        sed -i -ie "s;root=/dev/sda1;root=${host_lv_name_full};" ${grubdir}/menu.lst
    fi

    sed -i -e "s;onboot=yes;onboot=no;" ${partmnt}/etc/sysconfig/network-scripts/ifcfg-eth0
    sed -i -e 's;^timeout *[0-9]*$;timeout 1;' ${partmnt}/boot/grub/menu.lst
    if [ "${VIRT_METHOD}" = "lxc" ]; then
        sed -i -e "s; cgroup_disable=memory;;" ${grubdir}/menu.lst
    fi
}


function pi_update_efi_grub {
    local efi_dir=${1} 
    local host_lv=${2}
    local platform=${3}
    local boardtype=${4}
    local label=${5}
    local is_sim=${6}
    local grub_file=`find ${efi_dir} -name grub.cfg`

    sed -i -e "s;root=<P.*>; root=/dev/${host_lv} platform=${platform} boardtype=${boardtype} vmtype=hostos ima_tcb ima_appraise=log evm=off ima_appraise_tcb;" \
	   -e "s;noissu;;" \
	   -e "s;Install;Host;"\
	   -e "/ISSU/{N;N;N;N;N;N;N;d};"\
	   -e "s;<V.*>;${label};" ${grub_file} 
    if [ "$boardtype" == "CC" ]; then
        sed -i -e "s; pci=assign-busses; pci=use_crs;" \
            -e "s; aer=off;;" \
            ${grub_file}
    fi
    if [ "$is_sim" == 0 -a "$boardtype" != "LC" ]; then
        sed -i -e "s;ttyS0;ttyS1;"\
               -e "s;nointremap msireserve=133-182:0x2345,183-232:0x2346;;" \
               ${grub_file}
        platform=$(cat /proc/cmdline | awk -F "platform=" ' { print $2 }' | cut -d " "  -f1)
    fi
}

function pi_update_sysadmin_menu_lst {
    local PARTMNT=${1}
    local device=${2}
    local is_pxe_boot=${3}
    if ! test -e ${PARTMNT}/boot/grub/grub.conf ; then
        test -e ${PARTMNT}/boot/grub/menu.lst && ln -s ./menu.lst ${PARTMNT}/boot/grub/grub.conf
    fi
    # Before all invocations of the grub shell, call sync to make sure
    # the raw device is in sync with any bufferring in filesystems.
    sync
  
    if [ "${is_pxe_boot}" = "1" ]; then 
    # Now perform the installation.
    $grub_shell --batch $no_floppy --device-map=/dev/null <<EOF >&107 2>&1
device (hd1) ${device}
root (hd1,0)
setup $force_lba --stage2=${PARTMNT}/boot/grub/stage2 (hd1)
quit
EOF

    else
        /usr/bin/grubit.sh ${PARTMNT} ${device} 
    fi
    #fix menu.lst script
    sed -i -e "s;root (cd); root (hd0,0);" ${PARTMNT}/boot/grub/menu.lst
    if [ "$BOARDTYPE" == "RP" -o "$BOARDTYPE" == "SC" -o "$BOARDTYPE" == "CC" ]; then
      sed -i -e "s;bigphysarea=10M;bigphysarea=110M;"\
              ${PARTMNT}/boot/grub/menu.lst
    fi
    # VM always see it's part as sda/vda for virtio.
    sed -i -e "s;root=/dev/ram;root=LABEL=Calvados platform=${PLATFORM} boardtype=${BOARDTYPE} vmtype=sysadmin-vm;" ${PARTMNT}/boot/grub/menu.lst
    sed -i -e "s;ONBOOT=yes;ONBOOT=no;" ${PARTMNT}/etc/sysconfig/network-scripts/ifcfg-eth0
    if [ -f ${PARTMNT}/etc/sysconfig/network ]; then
        sed -i -e "s;HOSTNAME=host;HOSTNAME=sysadmin-vm;" ${PARTMNT}/etc/sysconfig/network
    fi
    if [ -f ${PARTMNT}/etc/hostname ]; then
        sed -i -e "s;host;sysadmin-vm;" ${PARTMNT}/etc/hostname
    fi
    sed -i -e "s;crashkernel=[^ ]*;crashkernel=0;" ${PARTMNT}/boot/grub/menu.lst
    sed -i -e "s;console=ttyS0;console=tty0 console=hvc0;" ${PARTMNT}/boot/grub/menu.lst

}

function getcmdlinearg {
    awk -vRS=' ' -vFS='='  /$1/' {print $2}' /proc/cmdline
}

function pi_update_onie_efi_grub {
    local efi_dir=${1} 
    local host_lv=${2}
    local platform=${3}
    local boardtype=${4}
    local label=${5}
    local grub_file=`find ${efi_dir} -name grub.cfg | grep grub/grub.cfg`

    echo "Update grub file $grub_file"
    # Rely on a update utility to modify GRUB parameters. 
    # Collect needed data and pass to the utility.
    BOARDTYPE=$(getcmdlinearg boardtype)
    if [ -n ${BOARDTYPE} ]; then
        ONL_PLATFORM=$(getcmdlinearg onl_platform)
        ONL_PRODUCT=$(getcmdlinearg onl_product)
        FILE="/lib/platform-config/${ONL_PLATFORM}/onl/etc/${ONL_PRODUCT}-onlinstall-config.yml"
        if [ -f ${FILE} ]; then
            # Do note with ONIE grub update, we need PD to export this utility.
            # Even though PI parameter updates, the update infra relies on PD provided
            # templates and configs.
            python /etc/init.d/grub_update_util.py -y ${FILE} -f ${grub_file} \
                                -r /dev/${host_lv} -l ${label} -p ${platform} \
                                -b ${BOARDTYPE}
            ret=$?
            if [ $ret -ne 0 ]; then
                echo "ERROR: Update utility wasnt able to update the V2 grub paramemter".
                return 1
            fi
        else
            echo "ERROR: $FILE not available to allow grub.cfg update"
            return 1
        fi
    fi
}
