#!/bin/bash
#
# -*-Shell-script-*-
#
# functions     This file contains functions to provision second disk 
#
# Copyright (c) 2014-2015 by Cisco Systems, Inc.
# All rights reserved.

 /usr/bin/logger -p 0 -t udev "(source: calvados/hostos_pkg/boot/scripts/Provision_disk_one.sh) "
#Source function library
. /etc/init.d/functions
. /etc/init.d/disk-functions
. /etc/init.d/spirit-functions

logger -s "Starting provision second disk"
/usr/bin/logger -p 0 -t udev "ecu : Starting provision second disk"

function on_sim {
   local cmdline=`cat /proc/cmdline`
   local CMD_SIM=`echo $cmdline | sed 's/^.*simulator=//' | cut -d" " -f1`
   if [ "$CMD_SIM" == "true" ]; then
       return 1
   fi

   local qemu_440chk=`lspci |grep -i 440FX |wc -l`
   local qemu_cpuchk=`cat /proc/cpuinfo |grep QEMU | wc -l`
   if [ "$qemu_440chk" != "0" -a "$qemu_cpuchk" != "0" ]; then
        return 1
    else
        return 0
    fi
}

# Check if this is simulation environment
on_sim
if (( $? != 0 )); then
    readonly SIMULATION=1
    echo "Running on SIMULATION PLATFORM"
else
    readonly SIMULATION=0
fi

#Passing the PCI diskname (sdb or sdc, ...) as first parameter
second_disk=${1}

if (( $SIMULATION )); then
    if [ -b /dev/vda ]; then
        disk=vda
    fi
    if [ -b /dev/vdb ]; then
        second_disk=vdb
    fi
fi #  $SIMULATION

/usr/bin/logger -p 0 -t udev "start: provision_disk_one ${second_disk}"
provision_disk_one ${second_disk}

logger -s "End of provision second disk"
/usr/bin/logger -p 0 -t udev "start: provision_disk_one ${second_disk}"

