#!/bin/bash
#
# This script provides PD changes on top of nwbridge.
#
# Copyright (c) 2015-2021 by Cisco Systems, Inc.
# All rights reserved.

# Possible values are RP, LC or SC

. /etc/init.d/mod_ins/module-load-functions
. /etc/init.d/pd-functions

# ioebc_br-nic is attached to the bridge ieobc_br by default
# deleting it to reduce one extra interface for multicast
brctl delif ieobc_br ieobc_br-nic

BOARDTYPE="$(proc_cmdline_get boardtype)"
if [ "$BOARDTYPE" == "RP" ]; then
    local MY_CARD_IDX="$(get_cmdline_card_index)"
    # Global vars
    MY_MOD_ID_HEX="$(my_slot_id x)"
    MY_MOD_ID="$(my_slot_id)"
    vconfig add ps-eobc 3073
    set_vlan_priority_map ps-eobc.3073
    ifconfig ps-eobc.3073 up
    /usr/sbin/brctl addif ieobc_br ps-eobc.3073
    /sbin/ifconfig ps-eobc 127.1.1.$MY_MOD_ID netmask 255.255.0.0 broadcast 127.1.255.255 mtu 9702
    /etc/init.d/nfsserver start
    /sbin/ifconfig eth0 promisc
    /sbin/ifconfig eth2 promisc
    /sbin/ifconfig eth3 promisc
    /sbin/ifconfig eth6 promisc
    /etc/init.d/dhcp-server start
    /sbin/ifconfig ps-inb promisc up

    nproc=`nproc`
    if [ "$nproc" -ge "12" ]; then
        cpumask="0ff"
    else
        cpumask="00f"
    fi
    echo $cpumask > /sys/devices/virtual/net/ieobc_br/queues/rx-0/rps_cpus
    echo $cpumask > /sys/devices/virtual/net/ieobc_br/queues/tx-0/xps_cpus

    sysctl -w net.core.netdev_max_backlog=2000
fi

boardtype=$(get_cctrl_board_type)
if [ "$boardtype" == "FC" ] || [ "$boardtype" == "XC" ]; then
    local MY_MOD_ID_HEX="$(my_slot_id x)"
    local MY_MOD_ID="$(my_slot_id)"
    if [ "$boardtype" = "XC" ]; then
    	ifconfig eth0 down
    	ifconfig eth0 mtu 9000 promisc
    	ip link set eth0 name eobc

        #MAC ADDRESS: 00:00:00:<eobc:0, epc:1>:<slot-id+1>:<card-type>
        #card-type: SUP = 1, LC = 2, FC = 3, SC = 4
        ifconfig eobc hw ether 00:00:00:00:$MY_MOD_ID_HEX:04
    else
        ifconfig hw-eobc0 down
        ifconfig hw-eobc0 mtu 9000 promisc

        ifconfig hw-eobc1 down
        ifconfig hw-eobc1 mtu 9000 promisc
    fi

    vconfig add eobc 3073
    set_vlan_priority_map eobc.3073
    ifconfig eobc up
    ifconfig eobc.3073 up

    /usr/sbin/brctl addif ieobc_br eobc.3073
    /sbin/ifconfig eobc 127.1.2.$MY_MOD_ID netmask 255.255.0.0 broadcast 127.1.255.255 mtu 9000

elif [ "$BOARDTYPE" == "LC" ]; then
    local MY_MOD_ID_HEX="$(my_slot_id x)"
    local MY_MOD_ID="$(my_slot_id)"
    local MY_CARD_IDX="$(get_cmdline_card_index)"

    ifconfig eth0 down
    ip link set eth0 name ps-eobc
    vconfig add ps-eobc 3073
    set_vlan_priority_map ps-eobc.3073
    ifconfig ps-eobc up

    if [ $MY_CARD_IDX -ne 27000 ] && 
       [ $MY_CARD_IDX -ne 27023 ] && 
       [ $MY_CARD_IDX -ne 27034 ] &&
       [ $MY_CARD_IDX -ne 27035 ] &&
       [ $MY_CARD_IDX -ne 27044 ] &&
       [ $MY_CARD_IDX -ne 27050 ] &&
       [ $MY_CARD_IDX -ne 27060 ] &&
       [ $MY_CARD_IDX -ne 27064 ] &&
       [ $MY_CARD_IDX -ne 27046 ] &&
       [ $MY_CARD_IDX -ne 27061 ] &&
       [ $MY_CARD_IDX -ne 27062 ] &&
       [ $MY_CARD_IDX -ne 27063 ] &&
       [ $MY_CARD_IDX -ne 27066 ] &&
       [ $MY_CARD_IDX -ne 27067 ] &&
       [ $MY_CARD_IDX -ne 27068 ] &&
       [ $MY_CARD_IDX -ne 27055 ]; then
        ifconfig bond0 down
        ip link set bond0 name ps-inb
    else 
        ifconfig eth1 down
        ip link set eth1 name ps-inb
    fi
    ifconfig ps-inb promisc up

    # Vigor Card idx is 27044 Punt inband is applicable for Vigor
    if [ "$MY_CARD_IDX" = "27044" ] ||
       [ "$MY_CARD_IDX" = "27050" ] ||
       [ "$MY_CARD_IDX" = "27046" ] ||
       [ "$MY_CARD_IDX" = "27061" ] ||
       [ "$MY_CARD_IDX" = "27062" ] ||
       [ "$MY_CARD_IDX" = "27063" ] ||
       [ "$MY_CARD_IDX" = "27066" ] ||
       [ "$MY_CARD_IDX" = "27067" ] ||
       [ "$MY_CARD_IDX" = "27068" ] ||
       [ "$MY_CARD_IDX" = "27055" ]; then
        #Create SPP bridge
        virsh -c lxc:/// net-define /etc/init/spp_br_network.xml
        virsh -c lxc:/// net-start spp_br
        brctl delif spp_br spp_br-nic

        vconfig add ps-inb 1538
        /sbin/ifconfig ps-inb.1538 mtu 9698 up
        brctl addif spp_br ps-inb.1538
 
        bridge fdb add  4e:41:50:00:10:01 dev ps-inb.1538 master temp
        bridge fdb add  4e:41:50:00:11:01 dev ps-inb.1538 master temp

        # Add BFD Bridge 
        virsh -c lxc:/// net-define /etc/init/olp_br_network.xml
        virsh -c lxc:/// net-start olp_br
        brctl delif olp_br olp_br-nic

        virsh -c lxc:/// net-define /etc/init/bfd_br_network.xml
        virsh -c lxc:/// net-start bfd_br
        brctl delif bfd_br bfd_br-nic

        # Add TPA Bridge 
        virsh -c lxc:/// net-define /etc/init/tpa_br_network.xml
        virsh -c lxc:/// net-start tpa_br
        brctl delif tpa_br tpa_br-nic

        vconfig add ps-inb 1794
        /sbin/ifconfig ps-inb.1794 mtu 9698 up
        brctl addif tpa_br ps-inb.1794

        vconfig add ps-inb 1554
        /sbin/ifconfig ps-inb.1554 mtu 9698 up
        brctl addif bfd_br ps-inb.1554
        
        # Single Router Bridge
        virsh -c lxc:/// net-define /etc/init/single_router_br_network.xml
        virsh -c lxc:/// net-start sr_br
        brctl delif sr_br sr_br-nic

        vconfig add ps-inb 1778
        /sbin/ifconfig ps-inb.1778 mtu 9698 up
        brctl addif sr_br ps-inb.1778
    fi
         

    /usr/sbin/brctl addif ieobc_br ps-eobc.3073
    /sbin/ifconfig ps-eobc 127.1.2.$MY_MOD_ID netmask 255.255.0.0 broadcast 127.1.255.255 mtu 9702
    /sbin/ifconfig ps-eobc promisc

fi

