#!/bin/sh
############Reading Bootloader version#############
echo "Reading Primary and Golden BIOS Version"
FLASH_LOG=/misc/disk1/ami_flash.log
echo "Log file $FLASH_LOG"
cmd="/opt/cisco/calvados/sbin/cmgr_show_spiflash | grep Bootloader"
str=$(eval "$cmd")

primary_bios_version=$(echo $str |cut -d ' ' -f 2)
active_str=$(echo $str |cut -d ' ' -f 6)

if [ "$active_str" = "Active" ];then
back_bios_version=$(echo $str |cut -d ' ' -f 9)
backup_flag=0
echo "Primary BIOS is active and backup_flag set to zero" > $FLASH_LOG
else
back_bios_version=$(echo $str |cut -d ' ' -f 8)
backup_flag=1
echo "Backup BIOS is active and backup_flag set to one" > $FLASH_LOG
fi
echo "Primary BIOS Version =$primary_bios_version" >> $FLASH_LOG
echo "Golden BIOS Version =$back_bios_version" >> $FLASH_LOG
app_path=/etc/rc.d/init.d/mod_ins/cisco-instance/fretta/
mod_path=/etc/rc.d/init.d/mod_ins/
bin_path=/opt/cisco/calvados/fpd/ucode/
##########Reading Bootloader ended################

##########Reading PID Name################
ssh 10.0.2.16 "dmidecode | grep Product | cut -d':' -f 2 > /misc/disk1/out"
scp -q 10.0.2.16:/misc/disk1/out .
str1=$(head -1 out)
pid_name="$(cut -d- -f1-2 <<<"$str1")"
echo "PID=$pid_name" >> $FLASH_LOG
##########Reading PID Name Endedd##########

if [ "$pid_name" = " NCS-55A2" ] || [ "$pid_name" = " NC55A2-MOD" ]; then
if [ "$primary_bios_version" = "1.14.0" ] || [ "$back_bios_version" = "1.14.0" ]; then
                echo "Peyto BIOS PID group">>$FLASH_LOG
                biosimg_gz=peyto-bios-v113_1.bin.gz
                biosimg=peyto-bios-v113_1.bin
                scp -q $app_path/afulnx_64 10.0.2.16:/misc/disk1/
                scp -q $mod_path/amifldrv_mod.o 10.0.2.16:/misc/disk1/
                scp -q $app_path/melock 10.0.2.16:/misc/disk1/
                scp -q $bin_path$biosimg_gz 10.0.2.16:/misc/disk1/
                ssh 10.0.2.16 "cd /misc/disk1/ && gunzip -f $biosimg_gz "
fi
    if [ "$primary_bios_version" = "1.14.0" ] ;then
        echo "Programming Primary BIOS" >> $FLASH_LOG
        if [ $backup_flag -eq 1 ]; then
       echo "Golden BIOS is active. Switching mux to Primary BIOS">>$FLASH_LOG
            val="0x88ff"
            if [[ ! -z `lspci -vd:100` ]];then
                                cmd1="lspci -vd:100|grep Memory"
                                str1=$(eval "$cmd1")
                                base_str1="$(cut -d' ' -f3 <<<"$str1")"
                                Ind0="${base_str1:0:2}"
                                Ind="${Ind0:0:1}"
                                bas="${Ind}8"
                                base_str1=${base_str1/$Ind0/$bas}
                                fpga_reg=${base_str1/%00/68}
                                sleep 0.2
                                ./melock -U
                                sleep 0.2
                                s=$(eval $"pcimemwrite 0x$fpga_reg 4 $val")
                                sleep 0.2
            else
                                echo "**********************************************************"
                                echo "**********************************************************"
                                echo "IOFPGA with DID:0x100 Not Found!!!">> $FLASH_LOG
                                echo "**********************************************************"
                                echo "**********************************************************"
            fi
        fi
        val1=0
        ssh 10.0.2.16 "cd /misc/disk1/ && ./afulnx_64 /S"
        ssh 10.0.2.16 "cd /misc/disk1/ && ./afulnx_64 /S"
        ssh 10.0.2.16 "cd /misc/disk1/ && ./afulnx_64 $biosimg /K /X /B /P /N 2>&1 | tee out"
        sleep 0.2
        scp -q 10.0.2.16:/misc/disk1/out .
        sleep 0.2
        tag=$( tail -n 1 out )
        if [ "$tag" = " Process completed." ]; then
        val1=1
        echo "Primary BIOS Programming Completed" >> $FLASH_LOG
        fi
        while [ $val1 -ne 1 ] && [ $loop -le 5 ]
        do
                        ssh 10.0.2.16 "cd /misc/disk1/ && ./biosimg $1 /K /X /B /P /N 2>&1 | tee out"
                        sleep 0.2
                        scp 10.0.2.16:/misc/disk1/out .
                        sleep 0.2
                        tag=$( tail -n 1 out )
                        echo "flash status $tag"
                        if [ "$tag" = " Process completed." ]; then
			val1=1
			echo "Primary BIOS Programming Completed" >> $FLASH_LOG
			break
                        fi
                        loop=$(( loop + 1 ))
        done

        if [ $backup_flag -eq 1 ]; then
            echo "Switching mux from Primary BIOS to Golden BIOS" >> $FLASH_LOG
            val="0x9cff"
            ./melock -U
            sleep 0.2
                        s=$(eval $"pcimemwrite 0x$fpga_reg 4 $val")
            sleep 0.2
            ./melock -L
        fi
        rm -rf /misc/disk1/out
        ssh 10.0.2.16 "rm -rf /misc/disk1/out"
	rm -rf /etc/cron.d/amiutil.crontab
    else
        echo "This Fretta PID's Primary BIOS is not effected">> $FLASH_LOG
    fi
        if [ "$back_bios_version" = "1.14.0" ]; then
        echo "Programming Golden BIOS" >> $FLASH_LOG
        if [ $backup_flag -eq 0 ]; then
               echo "Primary BIOS is active. Switching mux to Golden BIOS" >> $FLASH_LOG
               val="0x9cff"
             if [[ ! -z `lspci -vd:100` ]];then
              cmd1="lspci -vd:100|grep Memory"
              str1=$(eval "$cmd1")
              base_str1="$(cut -d' ' -f3 <<<"$str1")"
              Ind0="${base_str1:0:2}"
              Ind="${Ind0:0:1}"
              bas="${Ind}8"
              base_str1=${base_str1/$Ind0/$bas}
              fpga_reg=${base_str1/%00/68}
              sleep 0.2
              ./melock -U
               sleep 0.2
              s=$(eval $"pcimemwrite 0x$fpga_reg 4 $val")
              sleep 0.2
            else
              echo "**********************************************************"
              echo "**********************************************************"
              echo "IOFPGA with DID:0x100 Not Found!!!" >> $FLASH_LOG
              echo "**********************************************************"
              echo "**********************************************************"
                        fi
        fi
        val1=0
        ssh 10.0.2.16 "cd /misc/disk1/ && ./afulnx_64 /S"
        ssh 10.0.2.16 "cd /misc/disk1/ && ./afulnx_64 /S"
        ssh 10.0.2.16 "cd /misc/disk1/ && ./afulnx_64 $biosimg /K /X /B /P /N 2>&1 | tee out"
        sleep 0.2
        scp -q 10.0.2.16:/misc/disk1/out .
        sleep 0.2
        tag=$( tail -n 1 out )

        if [ "$tag" = " Process completed." ]; then
        val1=1
        echo "Golden BIOS flashing completed">> $FLASH_LOG
        fi

        loop=0
        while [ $val1 -ne 1 ] && [ $loop -le 5 ]
        do
            ssh 10.0.2.16 "cd /misc/disk1/ && ./biosimg $1 /K /X /B /P /N 2>&1 | tee out"
            sleep 0.2
            scp 10.0.2.16:/misc/disk1/out .
            sleep 0.2
                        tag=$( tail -n 1 out )
                        echo $tag
            if [ "$tag" = " Process completed." ]; then
		echo "Golden BIOS flashing completed">> $FLASH_LOG
                                val1=1
                                break
             fi
                        loop=$ $(( loop + 1 ))
        done

        if [ $backup_flag -eq 0 ]; then
            echo "Switching mux from Golden BIOS to Primary BIOS" >> $FLASH_LOG
            val="0x88ff"
                        ./melock -U
            sleep 0.2
                        s=$(eval $"pcimemwrite 0x$fpga_reg 4 $val")
            sleep 0.2
                        ./melock -L
        fi
        rm -rf /misc/disk1/out
        ssh 10.0.2.16 "rm -rf /misc/disk1/out"
	rm -rf /etc/cron.d/amiutil.crontab
    else
     echo "This Fretta PID's Backup(Golden) BIOS is not effected" >> $FLASH_LOG
    fi
elif [ "$pid_name" = " NCS-5502" ] || [ "$pid_name" = " NCS-5501" ]; then
if [ "$primary_bios_version" = "1.23.0" ] || [ "$back_bios_version" = "1.23.0" ]; then
        echo "Zermatt BIOS group">>$FLASH_LOG
        biosimg=zermattTurin-v1_22.bin
        biosimg_gz=zermattTurin-v1_22.bin.gz
        scp -q $app_path/afulnx_64 10.0.2.16:/misc/disk1/
        scp -q $mod_path/amifldrv_mod.o 10.0.2.16:/misc/disk1/
        scp -q $app_path/melock 10.0.2.16:/misc/disk1/
        scp -q $bin_path$biosimg_gz 10.0.2.16:/misc/disk1/
        ssh 10.0.2.16 "cd /misc/disk1/ && gunzip -f $biosimg_gz "
fi
    if [ "$primary_bios_version" = "1.23.0" ]; then
        if [ $backup_flag -eq 1 ]; then
            echo " Golden BIOS is active. Switching mux to Primary BIOS " >> $FLASH_LOG
            val="0x88ff"
          if [[ ! -z `lspci -vd:100` ]];then
              cmd1="lspci -vd:100|grep Memory"
              str1=$(eval "$cmd1")
              base_str1="$(cut -d' ' -f3 <<<"$str1")"
              Ind0="${base_str1:0:2}"
              Ind="${Ind0:0:1}"
              bas="${Ind}8"
              base_str1=${base_str1/$Ind0/$bas}
              fpga_reg=${base_str1/%00/68}
              sleep 0.2
              ./melock -U
              sleep 0.2
              s=$(eval $"pcimemwrite 0x$fpga_reg 4 $val")
              sleep 0.2
          else
              echo "**********************************************************"
              echo "**********************************************************"
              echo "IOFPGA with DID:0x100 Not Found!!!" >> $FLASH_LOG
              echo "**********************************************************"
              echo "**********************************************************"
          fi
        fi
        val1=0
        ssh 10.0.2.16 "cd /misc/disk1/ && ./afulnx_64 /S"
        ssh 10.0.2.16 "cd /misc/disk1/ && ./afulnx_64 /S"
        ssh 10.0.2.16 "cd /misc/disk1/ && ./afulnx_64 $biosimg /K /X /B /P /N 2>&1 | tee out"
        scp -q 10.0.2.16:/misc/disk1/out .
        tag=$( tail -n 1 out )

        if [ "$tag" = " Process completed." ]; then
        echo "Primary BIOS flashing completed">> $FLASH_LOG
        val1=1
        fi

        loop=0
        while [ $val1 -ne 1 ] && [ $loop -le 5 ]
        do
                        ssh 10.0.2.16 "cd /misc/disk1/ && ./biosimg $1 /K /X /B /P /N 2>&1 | tee out"
                        scp 10.0.2.16:/misc/disk1/out .
                        tag=$( tail -n 1 out )
                        echo $tag
                        if [ "$tag" = " Process completed." ]; then
			echo "Primary BIOS flashing completed">> $FLASH_LOG
                                val1=1
                                break
                        fi
                        loop=$(( loop + 1 ))
        done

        if [ $backup_flag -eq 1 ]; then
            echo "Switching mux from Primary BIOS to Golden BIOS">> $FLASH_LOG
            val="0x9cff"
                        ./melock -U
                        sleep 0.2
                        s=$(eval $"pcimemwrite 0x$fpga_reg 4 $val")
                        sleep 0.2
                        ./melock -L
        fi
        rm -rf /misc/disk1/out
        ssh 10.0.2.16 "rm -rf /misc/disk1/out"
	rm -rf /etc/cron.d/amiutil.crontab
    else
        echo "This Fretta PID's Primary BIOS is not effected" >> $FLASH_LOG
    fi
    if [ "$back_bios_version" = "1.23.0" ];then
        if [ $backup_flag -eq 0 ]; then
          echo "Primary BIOS is active. Switching mux to Golden BIOS" >> $FLASH_LOG
          val="0x9cff"
          if [[ ! -z `lspci -vd:100` ]];then
            cmd1="lspci -vd:100|grep Memory"
            str1=$(eval "$cmd1")
            base_str1="$(cut -d' ' -f3 <<<"$str1")"
            Ind0="${base_str1:0:2}"
            Ind="${Ind0:0:1}"
            bas="${Ind}8"
            base_str1=${base_str1/$Ind0/$bas}
            fpga_reg=${base_str1/%00/68}
            sleep 0.2
            ssh 10.0.2.16 "cd /misc/disk1/ && ./melock -U"
            s=$(eval $"pcimemwrite 0x$fpga_reg 4 $val")
            sleep 0.2
           else
            echo "**********************************************************"
            echo "**********************************************************"
            echo "IOFPGA with DID:0x100 Not Found!!!" >> $FLASH_LOG
            echo "**********************************************************"
            echo "**********************************************************"
          fi
        fi
        val1=0
        ssh 10.0.2.16 "cd /misc/disk1/ && ./afulnx_64 /S"
        ssh 10.0.2.16 "cd /misc/disk1/ && ./afulnx_64 /S"
        ssh 10.0.2.16 "cd /misc/disk1/ && ./afulnx_64 $biosimg /K /X /B /P /N 2>&1 | tee out"
        scp -q 10.0.2.16:/misc/disk1/out .
        tag=$( tail -n 1 out )

        if [ "$tag" = " Process completed." ]; then
        val1=1
        echo "Golden BIOS flashing completed">> $FLASH_LOG
        fi

        loop=0
        while [ $val1 -ne 1 ] && [ $loop -le 5 ]
        do
                        ssh 10.0.2.16 "cd /misc/disk1/ && ./biosimg $1 /K /X /B /P /N 2>&1 | tee out"
                        scp 10.0.2.16:/misc/disk1/out .
                        tag=$( tail -n 1 out )
                        echo $tag

                        if [ "$tag" = " Process completed." ]; then
			echo "Golden BIOS flashing completed">> $FLASH_LOG
                        val1=1
                        break
                        fi
                        loop=$(( loop + 1 ))
        done

        if [ $backup_flag -eq 0 ]; then
         echo "Switching mux from Golden BIOS to Primary BIOS " >> $FLASH_LOG
                        val="0x88ff"
                        ssh 10.0.2.16 "cd /misc/disk1/ && ./melock -U"
                        sleep 0.2
                        s=$(eval $"pcimemwrite 0x$fpga_reg 4 $val")
                        sleep 0.2
                        ssh 10.0.2.16 "cd /misc/disk1/ && ./melock -L"
                fi
                rm -rf /misc/disk1/out
                ssh 10.0.2.16 "rm -rf /misc/disk1/out"
		rm -rf /etc/cron.d/amiutil.crontab
    else
        echo "This Fretta PID's Backup(Golden) BIOS is not effected">> $FLASH_LOG
    fi
else
        echo "PID is not buggy BIOS" >>$FLASH_LOG
fi
