#!/bin/bash
#
# calvados/fretta_pkg/boot/scripts/fretta/pass-dyn-uio-lxc.sh
#
# This script has MPA specific functions for passing dynamic 
# UIO devies to the LC XR LXC
#
# Rahul Mathur
# 
# Ref : Dev-allow, devlist
#
# Copyright (c) 2017-2018, 2020-2021 by Cisco Systems, Inc.
# All rights reserved.
#

# Caller of this script is from the udev rules 
# Udev caller path: calvados/fretta_pkg/boot/scripts/fretta/mpa-uio.rules 

source /etc/rc.d/init.d/mod_ins/module-load-functions
source /etc/init.d/spirit_pd.sh

ABS_PATH_UIO="/sys/class/uio/uio*"
UIO_PATH_DEV="/dev/"
VIRSH_CMD_FIXED="virsh attach-device default-sdr--2"
VIRSH_CMD_MOD="virsh attach-device default-sdr--1"
VIRSH_CMD_SYS="virsh attach-device sysadmin"
# Description: This function does the following 
# 1. Take and argument about UIO device name
# 2. It will then create an absolute path for UIO device e.g: /dev/uio*
# 3. It will then create a small XML and add the device in #3 to the XML 
# 4. It will then dynamicall add the device from the LC XR LXC
create_xml_add_to_virsh(){
   local  uio_dev_path_abs
   local  fpga_id
   local  virsh_cmd
   init_iofpga_base_addr

   uio_dev_path_abs="$UIO_PATH_DEV$1"
   xml_path="/tmp/$1_add_tmp.xml"
   uio_name=$(cat /sys/class/uio/$1/name)
   boot_debug "uio name $uio_name"
   
   boot_debug "Abs path for uio $uio_dev_path_abs"

   echo '<hostdev mode="capabilities" type="misc"><source><char>'"$uio_dev_path_abs"'</char></source></hostdev>' > $xml_path

   fpga_id=$(iofpga_reg_read 0x4)

   # For modular LC card like Potenza MPA LC's we would do SDR1 and not 2 
   case "$fpga_id" in 
       # LC POTENZA+MPA
       0x0150532C)
           virsh_cmd=$VIRSH_CMD_MOD
           ;;
       #LC POTENZA+MPA TCAM
       0x0150532D)
           virsh_cmd=$VIRSH_CMD_MOD
           ;;
       # Peyto 
       0xA0171FD3)
           virsh_cmd=$VIRSH_CMD_FIXED
           ;;
       # Peyto without TCAM 
       0xB0171FD3)
           virsh_cmd=$VIRSH_CMD_FIXED
           ;;
       # Peyto without TCAM HD
       0xD0171FD3)
           virsh_cmd=$VIRSH_CMD_FIXED
           ;;
       # Peyto with TCAM HD CC
       0xF0171FD3)
           virsh_cmd=$VIRSH_CMD_FIXED
           ;;
       # Eyrie LC se & nonse 
       0x90744254)
           if [[ $uio_name == *"ALDRIN"* ]]; then
                boot_debug "Aldrin uio"
                virsh_cmd=$VIRSH_CMD_SYS
           else 
                boot_debug "non-Aldrin uio"
                virsh_cmd=$VIRSH_CMD_MOD
           fi
           ;;
       0x80744254)
           if [[ $uio_name == *"ALDRIN"* ]]; then
                boot_debug "Aldrin uio"
                virsh_cmd=$VIRSH_CMD_SYS
           else 
                boot_debug "non-Aldrin uio"
                virsh_cmd=$VIRSH_CMD_MOD
           fi
           ;;
       0x01601008) # VIGOR MOD LC
          virsh_cmd=$VIRSH_CMD_MOD
          ;;
       *)
           virsh_cmd=$VIRSH_CMD_FIXED
   esac
   
   boot_debug "virsh cmd for uio add: $virsh_cmd $xml_path uio_path=$uio_dev_path_abs"
   $virsh_cmd $xml_path
   rm $xml_path
}


boot_debug "Running pass-dyn-uio-lxc.sh"

boot_debug "Got $1 from UDEV for addition"
create_xml_add_to_virsh $1


