#!/bin/bash
#
# Copyright (c) 2010-2016, 2020 by cisco Systems, Inc.
# All rights reserved.
#
# Calvados launch script
# This script is called from host's upstart.
# Do not exit from the script. Upstart will keep on
# respaw the script again and again.
#
# Please do not call this script directly.
# The check must be performed prior to launching script.
#
# To stop calvados use initctl stop calvados
# To start calvados use initctl start calvados
#
# The event "initctl emit start-calvados" launches this script.
# Please look at calvados.conf in /etc/init/ for launch.
#
#  $1 ---> extra sanity to make sure it is launched from upstart
#  $2 ---> called during initctl stop, cleanup the VM
  
# Default VM name

VMNAME=sysadmin
SHUT_FILE=/tmp/Calvados_shut_status
DEBUG_FILE=/var/log/calvados_upstart.log
readonly PD_DYNAMIC="/opt/cisco/hostos/bin/calvados_launch_pd.sh"
if [ -f $PD_DYNAMIC ]; then
    . $PD_DYNAMIC
fi

readonly PI_DYNAMIC="/opt/cisco/hostos/bin/calvados_launch_common.sh"
if [ -f $PI_DYNAMIC ]; then
    . $PI_DYNAMIC
fi

wait_for_host_shut() {
while true
do
	echo "Waiting for host shutdown $(date)" >> $DEBUG_FILE 2>&1
	sleep 5
done
}

if [ "$1" == "upstart" ]; then
    if [ "$2" == "stop" ]; then
        calvados_stop_pd
        echo "Calvados stopped $(date)" >> $DEBUG_FILE 2>&1
    else 
        if [ -f "$SHUT_FILE" ]; then
            wait_for_host_shut		## Wait till host/board shut or reset
        else 
            calvados_start_pd
        fi
    fi
else
    echo
    echo
    echo "        This script can only be launched from upstart"
    echo "        Please do not call this script directly"
    echo "        Use "initctl stop calvados" to stop calvados"
    echo "        Use "initctl start calvados" to start calvados"
    echo
    echo
fi

