#!/usr/bin/env python
#
# Plugin for app_hosting_apply_cmd VRF support
#
# Copyright (c) 2017 by cisco Systems, Inc.
# All rights reserved.
#
import app_hosting_apply_cmd_util
import re


#
# VRF class for handling commands. Move to it's own import module
# if we end up adding more classes here. For now, overkill.
#
class VRF(object):

    def server_handle_vrf_add_cmd(self, vrf):
        return app_hosting_apply_cmd_util.shell(
                ["app_hosting_vrf_create.sh", vrf, "namespace"])

    def server_handle_vrf_del_cmd(self, vrf):
        return app_hosting_apply_cmd_util.shell(
                ["app_hosting_vrf_destroy.sh", vrf, "namespace"])

    def server_handle_vrf_show_cmd(self, vrf):
        return app_hosting_apply_cmd_util.shell(
                ["app_hosting_vrf_show.sh", vrf, "namespace"])

    def server_handle_vrf_ok_to_remove_cmd(self, vrf):
        return app_hosting_apply_cmd_util.shell(
                ["app_hosting_vrf_ok_to_remove.sh", vrf, "namespace"])

    def handle_command(self, cmd):

        #
        # Cut off anything that might look like a shell command being 
        # tagged onto the end of the legitimate command.
        #
        vrf = re.split('; `', cmd[2], flags=re.IGNORECASE)[0]

        HANDLE_COMMAND_LOOKUP = {
            "add" : self.server_handle_vrf_add_cmd,
            "del" : self.server_handle_vrf_del_cmd,
            "show" : self.server_handle_vrf_show_cmd,
            "ok_to_remove" : self.server_handle_vrf_ok_to_remove_cmd,
        }

        if cmd[1] not in HANDLE_COMMAND_LOOKUP:
            return (-1, "unknown VRF command {0}".format(cmd), "")

        return HANDLE_COMMAND_LOOKUP[cmd[1]](vrf)

    def description(self):

        return ("""
            vrf add <vrf>
            vrf del <vrf>
            vrf show <vrf>
            vrf ok_to_remove <vrf>
""")
