#!/bin/bash
#
# Copyright (c) 2017 by Cisco Systems, Inc.
#
# Provides ability to run hostos's linux command or
# locally if XR runs in VM.
# for list of commands run :-
#   /usr/sbin/app_hosting_apply_cmd_client.py -help

source /etc/init.d/app-hosting-functions &>/dev/null

function app_hosting_apply_host_cmd()
{
    local APP_HOSTING_APPLY_CMD_DIR=/misc/app_host/app_hosting_apply_cmd
    
    if app_hosting_is_vm; then
        app_hosting_log "Running host command locally"
        $*
    else 
        app_hosting_log "Running host command remotely"
        mkdir -p $APP_HOSTING_APPLY_CMD_DIR

        /usr/sbin/app_hosting_apply_cmd_client.py \
            --cmd "host_cmd $*" \
            --socket $APP_HOSTING_APPLY_CMD_DIR/socket
    fi
}

app_hosting_apply_host_cmd $*

