#! /usr/bin/python
#
# Cleanup file
#
# Copyright (c) 2019, 2021 by cisco Systems, Inc.
# All rights reserved.
#

import os
import sys
import time

root_dir = '/var/log'

verbose = 0

#10 seconds is interval to cleanup /var/log/ if install is in progress
CLEANUP_INTERVAL = 10
INSTALL_IN_PROGRESS = "/tmp/install_in_progress"
BLACK_LIST_FILES = ["user.log", "auth.log", "syslog", "cmpp.log", "confd_audit.log", "confd_developer.log","cm.log", "access.log", "postinstall.log", "relay.local.log", "confd_daemon.log", "ntp.log", "messages"]

confd_cap = 5*1024*1024

def clean_file_with_pattern(pattern):
    a_list = []
    total = 0
    for item in os.listdir(root_dir):
        if verbose == 1:
            print ("file name is:", item)

        for val in pattern:

            if verbose == 1:
                print ("pattern element is :", val)

            if val in item:

                item_name_and_path = os.path.join(root_dir, item)

                if verbose == 1:
                    print ("file name and path is: ", item_name_and_path)

                if os.path.isfile(item_name_and_path):
                    stat = os.stat(item_name_and_path)
                    a_list.append([int(stat.st_mtime), int(stat.st_size), item_name_and_path])

                    total = total + stat.st_size



    # sort by st_mtime
    if total >= confd_cap:

        if verbose == 1:
            print("list before sorting is:", a_list)

        a_list.sort(key=lambda x: x[0], reverse = True)

        if verbose == 1:
            print("list after sorting is:", a_list)

        total_again = 0

        # delete oldest first
        for i, val in enumerate(a_list):
            total_again = total_again + val[1]
            if total_again >= confd_cap:
                try:
                    if verbose == 1:
                        print("Truncating file :", total_again, i, val[2])

                    target = open(val[2],'w')
                    target.truncate(0)
                    if val[2] == "/var/log/relay.local.log":
                        target.close()
                        os.system('/opt/cisco/calvados/bin/cal_logger "truncated by file_cleanup.py, it is a cleanup mechanism and will not impact any functionality"')
                    else:
                        target.write("truncated by file_cleanup.py")
                        target.close()
                except:
                    pass


def clean_file_with_pattern_not_exists(pattern):
    #get lsof /var/log/, and check for any files, which are as (deleted)
    dlsof = os.popen("lsof /var/log/ | grep '(deleted)'").read() # Grep to avoid running loop for all entries
    dlsof = dlsof.split("\n")
    for line in dlsof :
        index = 0
        pid = -1
        fd = 0
        while (index < len(pattern)):
            if (pattern[index]+" (deleted)") in line :
                # deleted file is still in use, get pid, fd, and truncate 
                data = line.split()
                # If deleted file FD size is greater than 5MB
                if (int(data[6]) >= confd_cap) :
                    pid = int(data[1])  
                    fd = int(''.join(i for i in data[3] if i.isdigit()))
                    fp = open("/proc/" + str(pid) + "/fd/" + str(fd) , "w")
                    fp.truncate(0)
                    fp.close()
                    # No need to add trucate message, Since it is an stale FD

            index = index + 1

if __name__ == "__main__":

    # Flag used to cleanup the deleted files, atleast once
    cleanup_del_files = int(sys.argv[1])

    if (cleanup_del_files == 1) :
        # Run in normal mode. wd_sysmon called script to cleanup /var/log/ filesys.
        clean_file_with_pattern(BLACK_LIST_FILES)
        clean_file_with_pattern_not_exists(BLACK_LIST_FILES)

    if (cleanup_del_files == 2) :
        # Run in install in progress mode. cleanup the files which are deleted, and but not freed disk.
        while (os.path.exists(INSTALL_IN_PROGRESS)) : 
            clean_file_with_pattern(BLACK_LIST_FILES)
            clean_file_with_pattern_not_exists(BLACK_LIST_FILES)
            time.sleep(CLEANUP_INTERVAL)

