#!/bin/bash
#
# calvados/fretta_pkg/boot/scripts/xrnginstall-fretta-pd.sh
#
# This script has fretta specific install functions
#
# Neil McGill (based on work by Alphesh Patel)
# 
# Copyright (c) 2014-2021 by Cisco Systems, Inc.
# All rights reserved.
#

source /etc/rc.d/init.d/pd-functions

CARD_INST_FILE=/root/card_instances.txt

function xrnginstall_fretta_patch_common {

    local rootdir="$1"
    local bootdir=${rootdir}/boot

    get_board_type
    ARCH=`arch`

    #platform_get_settings
    platform_log "$FUNCNAME"
}

function fretta_host_cleanup () {
    local rootdir="$1"
    #remove noise
    if [ -f ${rootdir}/etc/rc3.d/S20dnsmasq ]; then
        rm ${rootdir}/etc/rc3.d/S20dnsmasq
    fi
    if [ -f ${rootdir}/opt/cisco/hostos/etc/sysconfig/modules/niantic.modules ]; then
        echo>${rootdir}/opt/cisco/hostos/etc/sysconfig/modules/niantic.modules
    fi
    declare -F pd_is_eyrie_rp_card &>/dev/null
        if [ $? -eq 0 ] && pd_is_eyrie_rp_card ; then
            if [ -f /lib/udev/rules.d/65-net-fretta-rp.rules ]; then
                rm /lib/udev/rules.d/65-net-fretta-rp.rules
                platform_log "Removed /lib/udev/rules.d/65-net-fretta-rp.rules on eyrie RP"
                echo "Removed /lib/udev/rules.d/65-net-fretta-rp.rules on eyrie RP"
            fi
        fi
    if [ ${BOARDTYPE} != "RP" ]; then
        platform_log "Removing RP-only udev rules"
        if [ -f /lib/udev/rules.d/65-net-fretta-rp.rules ]; then
            rm /lib/udev/rules.d/65-net-fretta-rp.rules
            platform_log "Removed /lib/udev/rules.d/65-net-fretta-rp.rules"
            echo "Removed /lib/udev/rules.d/65-net-fretta-rp.rules"
        fi
        if [ -f /lib/udev/rules.d/65-net-fretta-eyrie-rp.rules ]; then
            rm /lib/udev/rules.d/65-net-fretta-eyrie-rp.rules
            platform_log "Removed /lib/udev/rules.d/65-net-fretta-eyrie-rp.rules"
            echo "Removed /lib/udev/rules.d/65-net-fretta-eyrie-rp.rules"
        fi
    fi
}

function fretta_lxc_cleanup () {
    local rootdir="$1"
    #remove noise
    platform_log_console "Cleaning up LXC"   
    if [ -f ${rootdir}/etc/rc3.d/S20tftpd-hpa ]; then
        rm ${rootdir}/etc/rc3.d/S20tftpd-hpa
    fi
    if [ -f ${rootdir}/etc/rc3.d/S20dnsmasq ]; then
        platform_log_console "deleting rm ${rootdir}/etc/rc3.d/S20dnsmasq"   
        rm ${rootdir}/etc/rc3.d/S20dnsmasq
    fi
    if [ -f ${rootdir}/opt/cisco/hostos/etc/sysconfig/modules/niantic.modules ]; then
        echo>${rootdir}/opt/cisco/hostos/etc/sysconfig/modules/niantic.modules
    fi

}

# returns OK if $1 contains $2
strstr() {
  [ "${1#*$2*}" = "$1" ] && return 1
  return 0
}

function xrnginstall_fretta_patch_hostos {

    local rootdir="$1"
    local plat="$2"
    local hostvol="$3"
    local first_giga_mac
    sysupgaugustus="false"

    declare -F pd_is_augustus_card &>/dev/null
    if [ $? -eq 0 ] && pd_is_augustus_card ; then
        cmdline=`cat /proc/cmdline`
        if strstr "$cmdline" "dev/ram"; then
            sysupgaugustus="false"
        else
            sysupgaugustus="true"
        fi        
    fi

    xrnginstall_fretta_patch_common "$rootdir"

    # FRETTA_BRINGUP_HACK_rahmathu - CSCut92229 - abramach/hetsoi
    # Install libc6 32-bit RPM on the host for Fretta
    if [ "${ARCH}" == "x86_64" ]; then
        local libc6_rpm_file="${rootdir}/libc6-2.15+4.6a+136-r2.lib32_x86.rpm"
        if [ -f ${libc6_rpm_file} ]; then
            platform_log "Installing RPM ${libc6_rpm_file}"
            cd /
            STARTRPM=$(date +%s)
            chroot ${rootdir} rpm -i --nodeps `basename ${libc6_rpm_file}` >> /tmp/rpmlog 2>&1
            ENDRPM=$(date +%s)
            DIFFRPM=$(( $ENDRPM - $STARTRPM ))
            SIZERPM=$(ls -lh ${libc6_rpm_file}| awk '{ print $5 }')
            platform_log $"Install RPM ${libc6_rpm_file} of size ${SIZERPM} took ${DIFFRPM} sec"
        fi
    fi

    if [ ${BOARDTYPE} == "RP" ]; then
        platform_log "Patch DHCP and TFTP config"
        cat >${rootdir}/etc/default/dhcp-server <<%%
INTERFACES="ps-eobc"
%%
	cat >${rootdir}/etc/default/nfsd <<'%%'
NFSD_OPTION="-H $(ip addr show ps-eobc | awk -F'[ /]*' '{ if ($2 == "inet") print $3 }')"
cat >${rootdir}/etc/exports <<EOF
/misc/scratch/core 127.1.2.*(rw,sync,no_subtree_check)
EOF
mkdir -p /misc/scratch/core
chmod 777 /misc/scratch/core 
%%

        cat >${rootdir}/etc/default/tftpd-hpa <<%%
#Defaults for tftpd-hpa
RUN_DAEMON="yes"
OPTIONS="-l -c -s /misc/disk1/tftpboot"
%%
    fi

    platform_log "Patch host config"



    chroot ${rootdir} sed -i 's/VMTYPE=.*/VMTYPE=hostos/g' /etc/init.d/calvados_bootstrap.cfg

    sh /etc/init.d/flexr_symlink_cal.sh ${rootdir} 

    # Update init scripts
    #
    # Note: if your script doesn't need to handle any operation during shutdown
    #       (runlevel 0) or reboot (runlevel 6), don't use the "defaults"
    #       option, instead use "start" with the following syntax:
    #           "start  NN  runlevel  [runlevel] ."
    #       Note that you have to terminate the command with '.' after the list
    #       of runlevels.
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} host_booted_notif.sh  start 1 1 2 3 4 5 . > /dev/null 2>&1
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} check-flash  start 8 2 3 4 5 . > /dev/null 2>&1
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} cgroup-init  defaults 93  7 > /dev/null 2>&1
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} nwbridge     defaults 95  1 > /dev/null 2>&1
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} spirit       defaults 96  3 > /dev/null 2>&1

    # For fabric card add the kill script
    if [ "${BOARDTYPE}" == "FC" ]; then
        ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} fabric_disconnect.sh stop 10 0 6 . > /dev/null 2>&1
    fi

    mkdir -p ${rootdir}/etc/ld.so.conf.d
    if [ "${ARCH}" == "x86_64" ]; then
        cat > ${rootdir}/etc/ld.so.conf.d/hostos.conf <<%%
/opt/cisco/hostos/usr/lib64/
%%
        cat >> ${rootdir}/etc/sysctl.conf <<%%
net.core.rmem_max = 201326592
net.core.wmem_max = 67108864
net.core.rmem_default = 67108864
net.core.wmem_default = 67108864
net.core.netdev_max_backlog = 300000
net.core.optmem_max = 67108864
net.ipv4.udp_mem = 1124736     10000000  67108864
net.ipv4.udp_rmem_min = 1124736
net.ipv4.udp_wmem_min = 1124736
#
# Increased usage of ctrace facilities is skirting the default inotify watch
# limit of 8K on some platforms (with stress tests etc). Increase to future-proof.
# Should not increase any memory usage, as kernel does not pre-allocate.
# Also increase max_user_instances to 32K from 8K default.
#
fs.inotify.max_user_watches = 32768
fs.inotify.max_user_instances = 32768

vm.swappiness = 0
%%
    else
        cat > ${rootdir}/etc/ld.so.conf.d/hostos.conf <<%%
/opt/cisco/hostos/usr/lib/
%%
        ldconfig
    fi

    #make dir for lxc hooks and create symbolic link to the hook script
    mkdir -p ${rootdir}/etc/libvirt/hooks/
    ln -sf /etc/init.d/lxc_hook.sh ${rootdir}/etc/libvirt/hooks/lxc

    mkdir -p ${rootdir}/etc/profile.d
    cat > ${rootdir}/etc/profile.d/virsh.sh <<%%
export LIBVIRT_DEFAULT_URI=lxc:///
%%
    if [ "${BOARDTYPE}" == "RP" ]; then
        ln -s /misc/disk1/tftpboot/system_image.iso ${rootdir}/www/pages/
        ln -s /misc/disk1/tftpboot/ipxe-lc.ipxe.slot26 ${rootdir}/www/pages/
        ln -s /misc/disk1/tftpboot/ipxe-lc.ipxe.slot27 ${rootdir}/www/pages/
        ln -s /misc/disk1/tftpboot/ipxe-fc.ipxe.slot26 ${rootdir}/www/pages/
        ln -s /misc/disk1/tftpboot/ipxe-fc.ipxe.slot27 ${rootdir}/www/pages/
        ln -s /misc/disk1/tftpboot/fm.nbi ${rootdir}/www/pages/
        ln -s /misc/disk1/tftpboot/sc.nbi ${rootdir}/www/pages/
        ln -s /misc/disk1/tftpboot/sysadmin-nbi-initrd.img \
              ${rootdir}/www/pages/sysadmin-nbi-initrd.img 
    fi

    if [ "${BOARDTYPE}" == "XC" -o "${BOARDTYPE}" == "FC" ]; then
        mkdir -p ${rootdir}/misc/config
        mkdir -p ${rootdir}/misc/scratch
        source /etc/init.d/spirit_pd.sh
        declare -F pd_is_augustus_card &>/dev/null
        if [ $? -eq 0 ] && pd_is_augustus_card ; then
            # Aug-4 doesn't need cmdline, as it follows GRUB
            #dmidecode -t processor | grep Manufacture | grep Intel
            pd_is_augustus_arm_processor
            if [ "$?" -eq 0 ]; then
                cat /proc/cmdline > ${rootdir}/root/cmdline
                sed -i -e "s#root=/dev/ram#root=/dev/panini_vol_grp/$hostvol#g" "${rootdir}/root/cmdline"
            fi
        fi
        # If it is system upgrade, update cmdline parameters accordingly.
        if [[ "$sysupgaugustus" == true ]]; then
            cmdline=`cat ${rootdir}/root/cmdline`
            for token in $cmdline:
            do
                if [[ $token =~ "root=" ]]; then
                    sed -i -e "s;$token;root=/dev/panini_vol_grp/$hostvol;g" "${rootdir}/root/cmdline"
                fi
                if [[ $token =~ "vmtype=" ]]; then
                    sed -i -e "s;$token;vmtype=hostos;g" "${rootdir}/root/cmdline"
                fi
            done    
        fi
    fi
    fretta_host_cleanup ${rootdir}

    # FRETTA_BRINGUP_HACK: Ideally we want to run udev through rc scripts,
    #                      for now run it via /sbin/start_udev script
    rm ${rootdir}/etc/rcS.d/S*udev
}

function xrnginstall_fretta_patch_calvados {

    local rootdir="$1"
    local plat="$2"
    local lvid="${5:-0}"

    sysupgaugustus="false"

    declare -F pd_is_augustus_card &>/dev/null
    if [ $? -eq 0 ] && pd_is_augustus_card ; then
        cmdline=`cat /proc/cmdline`
        if strstr "$cmdline" "dev/ram"; then
            sysupgaugustus="false"
        else
            sysupgaugustus="true"
        fi        
    fi

    xrnginstall_fretta_patch_common "$rootdir"
    #Alpesh: generate the 10-sim rule to rename eth1 on calvados
    #need this only for calvados and XR  (and not for host)
    mkdir -p ${rootdir}/lib/udev/rules.d/
    echo 'KERNEL=="eth1", NAME="eth-vf1"' > ${rootdir}/lib/udev/rules.d/10-sim.rules

    platform_log "Patch network"
    cat >${rootdir}/etc/rc.d/rc.local <<%%
touch /var/lock/subsys/local
ifconfig eth-vf0 10.11.12.15/24 up
route add 10.0.2.16 eth-vf0
%%
    chmod a+x ${rootdir}/etc/rc.d/rc.local
    platform_log_exec cat ${rootdir}/etc/rc.d/rc.local

    chroot ${rootdir} ln -sf ./rc.d/rc.local /etc/rc.local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc2.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc3.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc4.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc5.d/S98local

    mkdir -p ${rootdir}/etc/ld.so.conf.d
    if [ "${ARCH}" == "x86_64" ]; then
        cat > ${rootdir}/etc/ld.so.conf.d/calvados.conf <<%%
/opt/cisco/calvados/usr/lib64/
%%
    else
        cat > ${rootdir}/etc/ld.so.conf.d/calvados.conf <<%%
/opt/cisco/calvados/usr/lib/
%%
    fi

    mkdir -p ${rootdir}/etc/profile.d
    cat > ${rootdir}/etc/profile.d/sysadmin.sh <<%%
PATH=$PATH:/opt/cisco/calvados/bin/:/opt/cisco/calvados/sbin/
%%
    chmod +x ${rootdir}/etc/profile.d/sysadmin.sh

    platform_log "Patch calvados config"

    if [ -f ${CARD_INST_FILE} ]; then
    grep -iqE -e "VIGOR-LC" -e "VIGOR-VE" -e "FRETTA-HYBRID-LC" ${CARD_INST_FILE}
        if [ "$?" -eq 0 ]; then
chroot ${rootdir} sed -i 's/ps-inb.1538/eth-vf2/g' /etc/init.d/calvados_bootstrap.cfg 
     fi
   fi

    chroot ${rootdir} sed -i 's/VMTYPE=.*/VMTYPE=sysadmin-vm/g' /etc/init.d/calvados_bootstrap.cfg

    local plat_type=$(iofpga_reg_read 0 4)
    num=$( printf "0x%x" $plat_type )
    data=$(($(( num >> 23 & 0x1 )) << 4 | $(( num >> 28 & 0xF ))))
    if [ $data -eq 23 ]
    then
        sed -i -e "s;VIRT_RP_MEM=4194304;VIRT_RP_MEM=1048576;" ${rootdir}/etc/init.d/calvados_bootstrap.cfg 
    fi 
    
    platform_log_exec cat ${rootdir}/etc/init.d/calvados_bootstrap.cfg

    platform_log "Set cmdline"
	if [ "${BOARDTYPE}" == "XC" -o "${BOARDTYPE}" == "FC" ]; then
      cat /proc/cmdline > ${rootdir}/root/cmdline
      sed -i -e "s/vmtype=hostos/vmtype=sysadmin-vm/" ${rootdir}/root/cmdline
      sed -i -e "s/$/ boardtype=${BOARDTYPE}/" ${rootdir}/root/cmdline

      source /etc/init.d/spirit_pd.sh
      declare -F pd_is_augustus_card &>/dev/null
      if [ $? -eq 0 ] && pd_is_augustus_card ; then
        sed -i -e "s#root=/dev/ram#root=/dev/panini_vol_grp/calvados_lv${lvid}#g" "${rootdir}/root/cmdline"
      fi

      pd_is_augustus_arm_processor
      is_arm=$?
      if [ "${is_arm}" -ne 0 ]; then
            sed -i -e "s#install=/dev/sda#card_index=$CARDINDEX#" "${rootdir}/root/cmdline"
      fi
      # If it is system upgrade, update cmdline parameters accordingly.
      if [[ "$sysupgaugustus" == true ]]; then
          cmdline=`cat ${rootdir}/root/cmdline`
          for token in $cmdline:
          do
              if [[ $token =~ "root=" ]]; then
                  sed -i -e "s;$token;root=/dev/panini_vol_grp/calvados_lv${lvid};g" "${rootdir}/root/cmdline"
              fi
              if [[ $token =~ "vmtype=" ]]; then
                  sed -i -e "s;$token;vmtype=sysadmin-vm;g" "${rootdir}/root/cmdline"
              fi
          done    
      fi
    else
      echo "root=/dev/panini_vol_grp/calvados_lv${lvid} platform=fretta boardtype=${BOARDTYPE} vmtype=sysadmin-vm console=ttyS2 prod=1 crashkernel=0 bigphysarea=100M quiet clocksource=jiffies elevator=noop" > ${rootdir}/root/cmdline 
    fi
 
    sh /etc/init.d/flexr_symlink_cal.sh ${rootdir} 

    # Update init scripts
    #
    # Note: if your script doesn't need to handle any operation during shutdown
    #       (runlevel 0) or reboot (runlevel 6), don't use the "defaults"
    #       option, instead use "start" with the following syntax:
    #           "start  NN  runlevel  [runlevel] ."
    #       Note that you have to terminate the command with '.' after the list
    #       of runlevels.
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} spirit defaults 96  3 > /dev/null 2>&1
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} check-flash  start 8 2 3 4 5 . > /dev/null 2>&1

    fretta_lxc_cleanup ${rootdir}

    rm ${rootdir}/etc/rcS.d/S*udev
   
    echo "#Disable containers to sync system clock and hw clock" >> ${rootdir}/etc/default/rcS 
    echo "HWCLOCKACCESS=no" >> ${rootdir}/etc/default/rcS
}

function xrnginstall_fretta_patch_remove_imcompatible_xr_files {
    local rootdir="$1"
    local filepath

    platform_log "$FUNCNAME"

    local ucs_imcompatible_xr_files=

    for filepath in ${ucs_imcompatible_xr_files[*]}; do
        rm ${rootdir}/${filepath}  >/dev/null 2>&1
    done
}

function xrnginstall_fretta_patch_xr {

    local rootdir="$1"
    local plat="$2"

    platform_log "$FUNCNAME"

    xrnginstall_fretta_patch_common "$rootdir"

    # 
    # The igb driver supports all 82575, 82576, 82580, and I350-based 
    # gigabit network connections.
    #
    sed -i -e "s;.*igb$;;" \
        ${rootdir}/etc/modprobe.d/blacklist.conf
    #
    # enic enables the support for the Cisco VIC Ethernet card.
    #
    sed -i -e "s;.*enic.*;;" \
        ${rootdir}/etc/modprobe.d/blacklist.conf

    #Alpesh: generate the 10-sim rule to rename eth1 on calvados
    #need this only for calvados and XR  (and not for host)
    mkdir -p ${rootdir}/lib/udev/rules.d/
    echo 'KERNEL=="eth1", NAME="eth-vf1"' > ${rootdir}/lib/udev/rules.d/10-sim.rules

    platform_log "Patch network"
    cat >${rootdir}/etc/rc.d/rc.local <<%%
touch /var/lock/subsys/local
ifconfig eth-vf0 10.11.12.14/24 up
route add 10.0.2.16 eth-vf0
%%
    chmod a+x ${rootdir}/etc/rc.d/rc.local
    platform_log_exec cat ${rootdir}/etc/rc.d/rc.local

    chroot ${rootdir} ln -sf ./rc.d/rc.local /etc/rc.local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc2.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc3.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc4.d/S98local
    chroot ${rootdir} ln -sf ../rc.local /etc/rc5.d/S98local

    mkdir -p ${rootdir}/etc/ld.so.conf.d
    cat > ${rootdir}/etc/ld.so.conf.d/xr.ldso.conf <<%%
/pkg/lib/
%%

    platform_log "Patch XR config"
    chroot ${rootdir} sed -i 's/VMTYPE=.*/VMTYPE=xr-vm/g' /etc/init.d/calvados_bootstrap.cfg
    platform_log_exec cat ${rootdir}/etc/init.d/calvados_bootstrap.cfg

    platform_log "Set cmdline"
    echo "root=/dev/panini_vol_grp/xr_lv0 platform=fretta boardtype=${BOARDTYPE} vmtype=xr-vm prod=1 crashkernel=0 bigphysarea=200M quiet clocksource=jiffies elevator=noop" > ${rootdir}/root/cmdline


    sh /etc/init.d/flexr_symlink_xr.sh ${rootdir} ${BOARDTYPE} >& /dev/null

    # Update init scripts
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} check-flash  start 8 2     3 4 5 . > /dev/null 2>&1

    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} spirit defaults 96 3 > /dev/null 2>&1
    ${rootdir}/usr/sbin/update-rc.d -v -r ${rootdir} -f lighttpd  remove > /dev/null 2>&1

    rm ${rootdir}/etc/rcS.d/S*udev

    echo "#Disable containers to sync system clock and hw clock" >> ${rootdir}/etc/default/rcS
    echo "HWCLOCKACCESS=no" >> ${rootdir}/etc/default/rcS

    #
    # This is a temporary workaround until calvados supports second disk on
    # the same device.
    #
    if [ ! -e ${rootdir}/harddisk: ]; then
        if [ ! -d ${rootdir}/misc/disk1 ]; then
            platform_log_exec mkdir -p ${rootdir}/misc/disk1
            if [ $? -ne 0 ]; then
                platform_log_exec "Failed to create /misc/disk1"
            fi
        fi

        if [ -d ${rootdir}/misc/disk1 ]; then
            platform_log_exec ln -sf /misc/disk1 ${rootdir}/harddisk:
            if [ $? -ne 0 ]; then
                platform_log_exec "Failed to link /harddisk:"
            fi
        fi
    fi

    # Fix the paths for XR

    mkdir -p ${rootdir}/etc/profile.d
    cat >> ${rootdir}/etc/profile.d/xr.sh <<'%%'
if  [ "$(id -u)" -eq 0 ] ; then
    if [ -f /pkg/etc/xr_startup_envs.sh ]; then
        source /pkg/etc/xr_startup_envs.sh
    fi
    if [ -f /tmp/set_env_vars ]; then
        source /tmp/set_env_vars
    fi
    if [ -f /pkg/bin/dnx_diag_shell_alias ]; then
        source /pkg/bin/dnx_diag_shell_alias
    fi
fi
%%
    chmod +x ${rootdir}/etc/profile.d/xr.sh
    fretta_lxc_cleanup ${rootdir}
}
