#!/bin/bash
#
# This script provides PD changes on top of nwbridge.
#
# Copyright (c) 2015-2020 by Cisco Systems, Inc.
# All rights reserved.


. /etc/init.d/spirit_pd.sh

# ioebc_br-nic is attached to the bridge ieobc_br by default
# deleting it to reduce one extra interface for multicast
brctl delif ieobc_br ieobc_br-nic

# eth-mgmt connects to management ethernet
# ps-inb connects to the EPC switch or Turin directly

/sbin/ifconfig eth-mgmt down
/usr/sbin/ethtool -K eth-mgmt gso off 
/usr/sbin/ethtool -K eth-mgmt tso off 
/usr/sbin/ethtool -K eth-mgmt lro off 
/usr/sbin/ethtool -K eth-mgmt gro off 

nproc=`nproc`
if [ "$nproc" -ge "12" ]; then
    cpumask="0ff"
else
    cpumask="00f"
fi
echo $cpumask > /sys/devices/virtual/net/ieobc_br/queues/rx-0/rps_cpus
echo $cpumask > /sys/devices/virtual/net/ieobc_br/queues/tx-0/xps_cpus

sysctl -w net.core.netdev_max_backlog=2000

#Create SPP bridge
virsh -c lxc:/// net-define /etc/init/spp_br_network.xml
virsh -c lxc:/// net-start spp_br
brctl delif spp_br spp_br-nic

#Create GSP bridge 
virsh -c lxc:/// net-define /etc/init/gsp_br_network.xml
virsh -c lxc:/// net-start gsp_br
brctl delif gsp_br gsp_br-nic

platform_type=$(iofpga_reg_read 0 4)
num=$( printf "0x%x" $platform_type )
result=$(($(( num >> 23 & 0x1 )) << 4 | $(( num >> 28 & 0xF ))))
case ${result} in
    1)  ;& # Zermatt
    2)  ;& # Turin
    3)  ;& # Taihu
    4)  ;& # Zermatt-CR
    23) ;& # Tortin-16G
    7)     # Tortin
        #create ps-inb.1538 and add it to spp_br
        /sbin/ifconfig ps-inb mtu 9702 up
        vconfig add ps-inb 1538
        set_vlan_priority_map ps-inb.1538

        brctl addif spp_br ps-inb.1538
        /sbin/ifconfig ps-inb.1538 mtu 9698 up

        get_num_npus 
        local num_npus=$?
        local mac_base="4e:41:50:00:00:"
        for ((i=0; i<$num_npus; i++)); do
            full_mac=$(printf '%s%x' $mac_base $((i + 0x11)))
            bridge fdb add $full_mac dev ps-inb.1538 master temp
        done
        ;;

    5)  ;& # Winterfell
    6)  ;& # OldCastle
    10)  ;& # Peyto
    11)  ;& # Peyto CR
    13)  ;& # Peyto CR HD
    15)  ;& # Peyto SE CC HD 
    8)  ;& # Pyke
    9)  ;& # OldCastleCR
    12) ;& # Bifrost-T
    14)	   # Turin-CR 
	
        # Add TP Bridge
        virsh -c lxc:/// net-define /etc/init/tp_br_network.xml
        virsh -c lxc:/// net-start tp_br
        brctl delif tp_br tp_br-nic

        # Add Single Router Bridge
        virsh -c lxc:/// net-define /etc/init/single_router_br_network.xml
        virsh -c lxc:/// net-start sr_br
        brctl delif sr_br sr_br-nic

        #Add OLP Bridge
        virsh -c lxc:/// net-define /etc/init/olp_br_network.xml
        virsh -c lxc:/// net-start olp_br
        brctl delif olp_br olp_br-nic

        # Add BFD Bridge
        virsh -c lxc:/// net-define /etc/init/bfd_br_network.xml
        virsh -c lxc:/// net-start bfd_br
        brctl delif bfd_br bfd_br-nic
        ;;
            
    *) 
       ;;
esac

