#!/bin/bash
#
# Copyright (c) 2016 by Cisco Systems, Inc.
# All rights reserved.
#
# This script only runs on host when OS is being halted to assert disconnect
# signal on FE3200 devices.
#

# import helpers
source /etc/init.d/spirit_pd.sh

# Init routines to access IOFPGA
get_board_type
init_iofpga_base_addr

case "$1" in
    start)
        ;;

    stop)
        # Assert FE3200 disconnect signal to prevent packet loss
        # Redirect the message to /dev/ksmg so it is logged in
        # /var/log/kern.log that will get saved into /mnt/pstore before
        # card is reset.
        echo "fabric_disconnect.sh: Asserting FE3200 disconnect signal ..." > /dev/kmsg

        reg_val=$(iofpga_reg_read 0x90)
        reg_val=$(($reg_val | 0xc003))
        iofpga_reg_write 0x90 $(printf 0x%08X $reg_val)
        ;;

    restart | reload | force-reload | status | condrestart | try-restart)
        ;;

    *)
        NAME=/etc/init.d/host_booted_notif.sh
        echo "Usage: $NAME {start}" >&2
        exit 1
        ;;
esac
