#!/bin/bash
#
# Copyright (c) 2015, 2018, 2020 by Cisco Systems, Inc.
# All rights reserved.
#
# This script only runs on host to send POST CODE to SC to indicate that
# HOST has booted.
# 

# import helpers
source /etc/init.d/spirit_pd.sh

case "$1" in
    start)
        VMTYPE=`cat /proc/cmdline | grep vmtype=`
        if [ -n "$VMTYPE" ]; then
            VMTYPE=`cat /proc/cmdline | sed 's/^.*vmtype=//' | cut -d" " -f1`
        fi

        if [ "$VMTYPE" == "hostos" ]; then
            BOARDTYPE=$(get_cctrl_board_type)
            declare -F pd_notify_host_started && pd_notify_host_started
            declare -F pd_is_augustus_card &>/dev/null 
            if [  $? -eq 0 ] && pd_is_augustus_card ; then
                declare -F pd_is_augustus_arm_processor
                if [ $? -eq 0 ]; then
                   pd_is_augustus_arm_processor
                        if [ "$?" -eq 0 ]; then
                            mount -n -o ro --bind /root/cmdline /proc/cmdline
                        fi
                fi
            fi
        fi
        ;;

    stop)
        ;;

    restart | reload | force-reload | status | condrestart | try-restart)
        ;;

    *)
        NAME=/etc/init.d/host_booted_notif.sh
        echo "Usage: $NAME {start}" >&2
        exit 1
        ;;
esac

exit 0
