#------------------------------------------------------------------
# cardmgr_log.py
#
# Copyright (c) 2020 by cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------

import os
import sys
from datetime import datetime
import shutil

if len(sys.argv) < 2:
    sys.exit(1) 

''' Maximum lines in log files '''
MAX_LINES_LOG = 50

history_file = "/misc/disk1/cardmgr_event.log"
tmp_history_file = "/tmp/cardmgr_event.log_tmp"

''' Open temporary file for writing, add latest log at the beginning '''
try:
    f = open (tmp_history_file,"w")
except Exception as e1:
    print("Failed to open card mgr event log temp file", e1)
    sys.exit(1) 

try:
    dateTimeObj = datetime.now()
    timestampStr = dateTimeObj.strftime("%Y %b %d %H:%M:%S.%f  ")
    f.write(timestampStr)
    f.write(sys.argv[1])
    f.write("\n")
except Exception as e1:
    print("Failed to write current event in card mgr event log temp file", e1)
    sys.exit(1) 

''' Read the log file and append to the temp file '''
try:
    if os.path.isfile(history_file):
        with open(history_file, "r") as fobj:
            for count, line in enumerate(fobj):
                if count >= MAX_LINES_LOG:
                    break
                ''' Append to temp file ''' 
                f.write(line)

    ''' Close temporary file  '''
    f.close()
except Exception as e1:
    print("Failed to append event in card mgr event log file", e1)
    sys.exit(1) 

''' Copy the temp file back to original location '''
try:
    if os.path.isfile(history_file):
        os.remove(history_file)
    shutil.copyfile(tmp_history_file, history_file)
    os.remove(tmp_history_file)
except Exception as e1:
    print("Failed to copy card mgr event log file", e1)
    sys.exit(1) 

