#!/bin/bash
#
# Implementation of forced reimage chassis operation done from host when
# there is no access to SysAdmin VM.
#
# Copyright (c) 2016 by Cisco Systems, Inc.
# All rights reserved.

# spirit_pd.sh script that has all the IOFPGA access functions
source /etc/init.d/spirit_pd.sh

# Set global variables 
force=0

# Show usage for script
function show_help {
    echo "Usage  force_reimage_chassis.sh [opt]"
    echo "-f     skip prompt (used by scripts)"
}

# Prompt user for confirmation
function ask_yes_or_no() {
    read -p "$1 ([y]es or [N]o): "
    case $(echo $REPLY | tr '[A-Z]' '[a-z]') in
        y|yes) echo "yes" ;;
        *)     echo "no" ;;
    esac
}

INTERAL_PXE_BOOT_MODE=1
EXTERNAL_PXE_BOOT_MODE=2

RP_BIOS_BOOT_MODE_REG_ADDR=0x50
#
# Set Local RP BIOS Boot Mode
function set_local_rp_bios_boot_mode() {
    iofpga_reg_write 0 $RP_BIOS_BOOT_MODE_REG_ADDR $EXTERNAL_PXE_BOOT_MODE
}

# Parse command line options first
while getopts "f" opt; do
    case $opt in
        f)
            force=1
            ;;
        \?)
            echo "Invalid option"
            show_help
            exit 1
            ;;
    esac
done

# Get the IOFPGA base address
init_iofpga_base_addr

# Get board type that is required to use IOFPGA functions defined in
# spirit_pd.sh script.
get_board_type

# Make sure that we are running from RP
if [ "$BOARDTYPE" != "RP" ]; then
    echo "ERROR: Running from wrong card type of $BOARDTYPE. Reimage operation can only be performed from RP"
    exit 1
fi


echo "WARNING: this script will attempt to set boot mode without any checks reboot the system for re-image operation "

# Prompt the user before continue
if [ "$force" -eq 0 ]; then
    if [ $(ask_yes_or_no "Continue") == "no" ]; then
        echo "Skipped!"
        exit 0
    fi
fi

# And then for the local RP
echo "Configuring local RP for external PXE boot ..."
set_local_rp_bios_boot_mode

# Last thing to do is system reset
RP_RESET_CTRL_REG_ADDR=0x74
RP_RESET_CTRL_BIT_SYS_RESET=0x1
echo "Performing system-wide reset to start reimage operation ..."
sleep 0.5

iofpga_reg_write 0 $RP_RESET_CTRL_REG_ADDR $RP_RESET_CTRL_BIT_SYS_RESET
