#!/bin/bash
#------------------------------------------------------------------------------
# host_pf_switchover_wbd.sh                     
#
# Jan 2020
#
# Copyright (c) 2020-2021 by cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------------------

cc_lc_ports=(3073 3074 1538 1794)
fc_ports=(3073)

date >> /var/log/pf_vf_switchover.log
echo $@ >> /var/log/pf_vf_switchover.log
XR_BOOTSTRAP_FILE="/usr/local/calvados/vm_manager/default-sdr--1/vmm_guest_bootstrap.cfg"
RN="$(cat $XR_BOOTSTRAP_FILE|awk -F"RACK_NUMBER=" '{print $2}')"

for pf_val in {1..2}
do
    if [ "$4" = "CC" ] || [ "$4" = "LC" ] ; then
        if [ $pf_val -eq $1 ]
        then
            for i in "${cc_lc_ports[@]}"
            do
                ip link set dev eth-pf$pf_val.$i up   2>> /var/log/pf_vf_switchover.log
            done
            for rak in {0..48}
            do
                rak_hex=$( printf "%02x" ${rak} )
                remote_np_mac="4e:41:50:$rak_hex:00:71"
                if [ $1 -eq 1 ];then
                    if [ $rak -ne $RN ]; then
                        bridge fdb del $remote_np_mac dev eth-pf2.1538 master temp
                        bridge fdb add $remote_np_mac dev eth-pf1.1538 master temp
                    fi
                fi
                if [ $1 -eq 2 ];then
                    if [ $rak -ne $RN ]; then
                        bridge fdb del $remote_np_mac dev eth-pf1.1538 master temp
                        bridge fdb add $remote_np_mac dev eth-pf2.1538 master temp
                    fi
                fi
            done
        else
            for i in "${cc_lc_ports[@]}"
            do
                ip link set dev eth-pf$pf_val.$i down 2>> /var/log/pf_vf_switchover.log
            done
        fi
    elif [ "$4" = "FC" ] ; then
        if [ $pf_val -eq $1 ]
        then
            for i in "${fc_ports[@]}"
            do
                ip link set dev eth-pf$pf_val.$i up   2>> /var/log/pf_vf_switchover.log
            done
        else
            for i in "${fc_ports[@]}"
            do
                ip link set dev eth-pf$pf_val.$i down 2>> /var/log/pf_vf_switchover.log
            done
        fi
    fi

    if [ "$4" = "CC" ] ; then
        if [ $pf_val -eq $1 ]
        then
            brctl addif onie_bmc_br eth-pf$pf_val    2>> /var/log/pf_vf_switchover.log
        else
            brctl delif onie_bmc_br eth-pf$pf_val    2>> /var/log/pf_vf_switchover.log
        fi
    fi
done

date >> /var/log/pf_vf_switchover.log

echo "pf switchover requested to pf$1" >> /var/log/pf_vf_switchover.log
echo "=====================================" >> /var/log/pf_vf_switchover.log
