#!/bin/bash
#
# calvados/fretta_pkg/boot/scripts/fretta/mtd_passthrough.sh
#
# The script passing dynamic mtd/ubi device to sysadmin/XR LXC
#
# Copyright (c) 2017-2018 by Cisco Systems, Inc.
# All rights reserved.
#
# Caller of this script is from the udev rules 
# Udev caller path: calvados/fretta_pkg/boot/scripts/fretta/88-mtd.rules 

source /etc/rc.d/init.d/mod_ins/module-load-functions
source /etc/init.d/spirit_pd.sh

MTDUBILOG=/dev/null
# MTDUBILOG=/root/mtd_passthrough.log


# Description: This function does the following 
# 1. Take the argumnet about MTD and UBI device name
# 2. Take the argumnet about add or remove device event
# 3. It will then create an absolute path for MTD device e.g: /dev/mtd*
# 4. It will then create a small XML and add the device in #3 to the XML 
# 5. It will then dynamically allow the device to be passed/removed to 
#    the sysadmin/XR LXC
create_xml_add_to_virsh(){
    local  dev_path_abs
    local  event 
    local  virsh_cmd

    event=$1
    dev=$2

    dev_path_abs="/dev/$dev"
    TMP_XML=$(mktemp /tmp/XXXXXX.xml)

    echo "Abs path for mtd: event: $event, dev: $dev, dev_path_abs: $dev_path_abs, TMP_XML: $TMP_XML" >> $MTDUBILOG 

    # pass mtd3, ubi3/ubi3_0 to sysadmin LXC, mtd5, ubi5/ubi5_0 to XR LXC

    echo '<hostdev mode="capabilities" type="misc"><source><char>'"$dev_path_abs"'</char></source></hostdev>' > $TMP_XML

    if [ "$event" = "add" ]; then
        CMD=attach-device
    else
        CMD=detach-device
    fi

    if [[ "$dev" = "ubi3" || ${dev:0:5} = "ubi3_" ]]; then 
        DOMAIN=sysadmin
    elif [[ "$dev" = "ubi5" || ${dev:0:5} = "ubi5_" ]]; then
        DOMAIN=default-sdr--1
    fi

    if [ -n "$CMD" -a -n "$DOMAIN" ]; then
        virsh $CMD $DOMAIN $TMP_XML
        if [ $? -ne 0 ]; then
        # Retry: If node already available in guest through other mechanisms, 
        # attach could fail and retry would succeed
            virsh $CMD $DOMAIN $TMP_XML
        fi
    fi

    rm $TMP_XML

    echo "Running pass-mtd-lxc.sh, at the end of create_xml_add_to_virsh" >> $MTDUBILOG 
}


# Run thru the uio device and match which is of intertest
# called from udev rules, pass-mtd-lxc.sh $mtd_dev

event=$ACTION
ubi_dev=$1

echo "$(date): Running mtd_passthrough.sh, event: $event, ubi_dev: $ubi_dev" >> $MTDUBILOG 
# if ACTION is not add or remove, just exit.
if [ x"$ACTION" != x"add" -a x"$ACTION" != x"remove" ]; then exit 0; fi

echo "$(date): call create_xml_add_to_virsh, event: $event, ubi_dev: $ubi_dev" >> $MTDUBILOG
create_xml_add_to_virsh $event $ubi_dev

