#!/bin/sh
#
# create_npu_inband.sh
# Copyright (c) 2014-2020 by Cisco Systems, Inc.

#import common helpers
. /etc/init.d/mod_ins/module-load-functions
. /etc/init.d/spirit_pd.sh

create="$1"
pcie_bus="$2"
inband_name="$3"
inband_num=${inband_name//[^0-9]/}
mac_base="4e:41:50:00:00:"
mac_last=$((inband_num + 0x11))

BCM_MTU=9728
PSINB_MTU=9702
VLAN_MTU=9698

SPP_VLAN=1538
OLP_VLAN=1570
TP_VLAN=1794
BFD_VLAN=1554
SINGLE_ROUTER_VLAN=1778

echo -n  "$1 ps-inb interface $inband_name $pcie_bus bcm$pcie_bus $inband_name.$SPP_VLAN $inband_name.$TP_VLAN $inband_name.$SINGLE_ROUTER_VLAN"

if [ "$create" == "start" ]; then 

    full_mac=$(printf '%s%x' $mac_base $mac_last)
    python /usr/sbin/bcm-knet-init.py $create 0x$pcie_bus $inband_name 
    /sbin/ifconfig bcm-$pcie_bus mtu $BCM_MTU up
    /sbin/ifconfig $inband_name mtu $PSINB_MTU up

    vconfig add $inband_name $SPP_VLAN
    set_vlan_priority_map $inband_name.$SPP_VLAN
    /sbin/ifconfig $inband_name.$SPP_VLAN mtu $VLAN_MTU up
    brctl addif spp_br $inband_name.$SPP_VLAN
    bridge fdb add $full_mac dev $inband_name.$SPP_VLAN master temp

    vconfig add $inband_name $TP_VLAN
    /sbin/ifconfig $inband_name.$TP_VLAN mtu $VLAN_MTU up
    brctl addif tp_br $inband_name.$TP_VLAN
    bridge fdb add $full_mac dev $inband_name.$TP_VLAN master temp

    vconfig add $inband_name $OLP_VLAN
    /sbin/ifconfig $inband_name.$OLP_VLAN mtu $VLAN_MTU up
    brctl addif olp_br $inband_name.$OLP_VLAN
    bridge fdb add $full_mac dev $inband_name.$OLP_VLAN master temp

    vconfig add $inband_name $BFD_VLAN
    /sbin/ifconfig $inband_name.$BFD_VLAN mtu $VLAN_MTU up
    brctl addif bfd_br $inband_name.$BFD_VLAN
    bridge fdb add $full_mac dev $inband_name.$BFD_VLAN master temp

    vconfig add $inband_name $SINGLE_ROUTER_VLAN
    /sbin/ifconfig $inband_name.$SINGLE_ROUTER_VLAN mtu $VLAN_MTU up
    brctl addif sr_br $inband_name.$SINGLE_ROUTER_VLAN
    bridge fdb add $full_mac dev $inband_name.$SINGLE_ROUTER_VLAN master temp
else
    vconfig rem $inband_name.$SPP_VLAN
    vconfig rem $inband_name.$TP_VLAN
    vconfig rem $inband_name.$OLP_VLAN
    vconfig rem $inband_name.$BFD_VLAN
    vconfig rem $inband_name.$SINGLE_ROUTER_VLAN

    /sbin/ifconfig $inband_name down
    /sbin/ifconfig bcm-$pcie_bus down
    python /usr/sbin/bcm-knet-init.py $create 0x$pcie_bus $inband_name
fi
