/*
 * Decompiled with CFR 0.152.
 */
package wlanbulk.view;

import java.net.InetAddress;
import wlanbulk.view.StringUtil;

public class InputValidation {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validateIPv4Address(String address) {
        try {
            String[] octets = StringUtil.split(address, '.');
            boolean allones = true;
            boolean allzeroes = true;
            if (octets.length != 4) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= octets.length) {
                    return !allones && !allzeroes;
                }
                String octet_str = octets[i];
                int octet_val = Integer.parseInt(octet_str);
                if (octet_str.length() == 0 || octet_val < 0 || octet_val > 255) {
                    return false;
                }
                allones = allones && octet_val == 255;
                allzeroes = allzeroes && octet_val == 0;
                ++i;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validateIPv6Address(String address) {
        try {
            String[] sections = StringUtil.split(address, ':');
            boolean allones = true;
            boolean abbreviationUsed = false;
            if (address.equals("::")) {
                return false;
            }
            if (sections.length > 8) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= sections.length) {
                    return !allones;
                }
                String sectionStr = sections[i].toLowerCase();
                if (sectionStr.length() > 4) {
                    return false;
                }
                if (!InputValidation.isHexNumber(sectionStr)) {
                    return false;
                }
                if (sectionStr.equals("")) {
                    if (abbreviationUsed) {
                        return false;
                    }
                    abbreviationUsed = true;
                }
                allones = allones && sectionStr.equals("ffff");
                ++i;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isHexNumber(String str) {
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c != '0' && c != '1' && c != '2' && c != '3' && c != '4' && c != '5' && c != '6' && c != '7' && c != '8' && c != '9' && c != 'A' && c != 'B' && c != 'C' && c != 'D' && c != 'E' && c != 'F' && c != 'a' && c != 'b' && c != 'c' && c != 'd' && c != 'e' && c != 'f') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean validateIPv4Subnet(String subnet) {
        byte[] ip_bytes;
        if (!InputValidation.validateIPv4Address(subnet)) {
            return false;
        }
        try {
            ip_bytes = InetAddress.getByName(subnet).getAddress();
        }
        catch (Exception e) {
            return false;
        }
        long ip_int = ip_bytes[0] << 24 & 0xFF000000 | ip_bytes[1] << 16 & 0xFF0000 | ip_bytes[2] << 8 & 0xFF00 | ip_bytes[3] << 0 & 0xFF;
        float ip_float = ip_int & -ip_int;
        int prefix_len = (Float.floatToIntBits(ip_float) >> 23) - 127;
        if (prefix_len <= 0) {
            return false;
        }
        if (prefix_len >= 32) {
            return false;
        }
        return ((ip_int ^ 0xFFFFFFFFFFFFFFFFL) & ((1L << prefix_len) - 1L ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }
}

