/*
 * Decompiled with CFR 0.152.
 */
package wlanbulk.view;

import java.text.StringCharacterIterator;

public class StringUtil {
    public static final String TAB = "\t";
    public static final String EMPTY_STRING = "";
    public static final String PLACE_HOLDER = "-";

    public static final String[] split(String values, char delimiter) {
        if (values.indexOf(delimiter) == -1) {
            return new String[]{values};
        }
        int count = 1;
        int end = 0;
        while ((end = values.indexOf(delimiter, end)) != -1) {
            ++count;
            ++end;
        }
        String[] valuesArray = new String[count];
        count = 0;
        end = 0;
        int begin = 0;
        while ((end = values.indexOf(delimiter, end)) != -1) {
            valuesArray[count++] = values.substring(begin, end).trim();
            begin = ++end;
        }
        valuesArray[count] = values.substring(begin);
        return valuesArray;
    }

    public static final String replaceText(String theOrigText, String theOldPattern, String theNewPattern) {
        if (theOldPattern.equals(EMPTY_STRING)) {
            return theOrigText;
        }
        StringBuffer result = new StringBuffer();
        int startIdx = 0;
        int idxOld = 0;
        while ((idxOld = theOrigText.indexOf(theOldPattern, startIdx)) >= 0) {
            result.append(theOrigText.substring(startIdx, idxOld));
            result.append(theNewPattern);
            startIdx = idxOld + theOldPattern.length();
        }
        result.append(theOrigText.substring(startIdx));
        return result.toString();
    }

    public static String formatStringByLength(String string, int length) {
        int len = string.length();
        if (len < length) {
            int i = 0;
            while (i < (length - len) / 8 + 1) {
                string = String.valueOf(string) + TAB;
                ++i;
            }
            return string;
        }
        return String.valueOf(string.substring(0, length)) + TAB;
    }

    public static String markIfStringIsBlank(String string) {
        if (string == null || string.trim().equals(EMPTY_STRING)) {
            return PLACE_HOLDER;
        }
        return string;
    }

    public static String formatStringByLengthSpaces(String string, int desiredLength) {
        int len = string.length();
        if (len < desiredLength) {
            int i = 0;
            while (i < desiredLength - len) {
                string = String.valueOf(string) + " ";
                ++i;
            }
            return string;
        }
        return string.substring(0, desiredLength);
    }

    public static String bytesToHex(byte[] data) {
        char[] hex = new char[data.length * 2];
        char[] base = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int i = 0;
        while (i < data.length) {
            int v = data[i] & 0xFF;
            hex[2 * i] = base[data[i] >>> 4];
            hex[2 * i + 1] = base[data[i] & 0xF];
            ++i;
        }
        return String.valueOf(hex);
    }

    public static final String replaceFirstInstance(String theOrigText, String theOldPattern, String theNewPattern) {
        int startIdx = 0;
        int idxOld = theOrigText.indexOf(theOldPattern, startIdx);
        if (theOrigText.length() > 0 && idxOld >= 0) {
            StringBuffer result = new StringBuffer();
            result.append(theOrigText.substring(startIdx, idxOld));
            result.append(theNewPattern);
            startIdx = idxOld + theOldPattern.length();
            result.append(theOrigText.substring(startIdx));
            return result.toString();
        }
        return theOrigText;
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isAlpha(String value) {
        char[] chars = value.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!Character.isLetter(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAlphaNum(String value) {
        char[] chars = value.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!Character.isLetter(chars[i]) && !Character.isDigit(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isBase64(String value) {
        char[] chars = value.toCharArray();
        char[] base64SpecialChars = new char[]{'=', '/', '+'};
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (!Character.isLetter(c) && !Character.isDigit(c)) {
                boolean special_char_found = false;
                int j = 0;
                while (j < base64SpecialChars.length) {
                    if (base64SpecialChars[j] == c) {
                        special_char_found = true;
                    }
                    ++j;
                }
                if (!special_char_found) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static String forXML(String input) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(input);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }
}

