/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.proxy;

import com.cisco.util.Debugger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;

public final class HttpProxy {
    private String proxyHost;
    private String proxyPort;

    public HttpProxy(String host, String port) {
        this.proxyHost = host;
        this.proxyPort = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getHttpDataViaProxy(String targetUrl) {
        String ContentLengthString = "content-length: ";
        byte[] data = null;
        SocketConnection conn = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            Debugger.print(4, "HttpProxy> Connecting to proxy: " + this.proxyHost + ":" + this.proxyPort);
            conn = (SocketConnection)Connector.open((String)("socket://" + this.proxyHost + ":" + this.proxyPort));
            conn.setSocketOption((byte)0, 1);
            conn.setSocketOption((byte)1, 0);
            conn.setSocketOption((byte)3, 8192);
            conn.setSocketOption((byte)4, 512);
            os = conn.openOutputStream();
            is = conn.openInputStream();
            os.write(this.getRequestHeader(targetUrl).getBytes());
            os.flush();
            Debugger.print(4, "HttpProxy> Request header sent, waiting for response...");
            ByteArrayOutputStream contentStream = new ByteArrayOutputStream();
            ByteArrayOutputStream headerStream = new ByteArrayOutputStream(800);
            boolean readingHeader = true;
            int numCRs = 0;
            int numLFs = 0;
            int contentLength = 0;
            boolean lenGiven = false;
            while (true) {
                int actual;
                if ((actual = is.read()) == -1 || lenGiven && contentStream.size() == contentLength) {
                    if (readingHeader) {
                        Debugger.print(1, "HttpProxy>> Stream ended while reading header.");
                        data = null;
                        break;
                    }
                    if (lenGiven && contentStream.size() != contentLength) {
                        Debugger.print(1, "HttpProxy>> Content-Length given, but not matched to stream length.");
                        data = null;
                        break;
                    }
                    data = contentStream.toByteArray();
                    break;
                }
                if (readingHeader) {
                    headerStream.write(actual);
                    if (actual == 13) {
                        ++numCRs;
                        continue;
                    }
                    if (actual == 10) {
                        if (++numLFs != 2 || numCRs != 2) continue;
                        String hdrText = new String(headerStream.toByteArray());
                        int responseStatus = Integer.parseInt(hdrText.substring(9, 12));
                        if (responseStatus != 200) {
                            throw new IllegalStateException("HttpProxy>> Response-Code is: " + responseStatus);
                        }
                        int clPos = hdrText.toLowerCase().indexOf("content-length: ");
                        if (clPos == -1) {
                            lenGiven = false;
                        } else {
                            contentLength = Integer.parseInt(hdrText.substring(clPos + "content-length: ".length(), hdrText.indexOf("\r\n", clPos + "content-length: ".length() + 1)));
                            lenGiven = true;
                        }
                        headerStream.close();
                        readingHeader = false;
                        continue;
                    }
                    numCRs = 0;
                    numLFs = 0;
                    continue;
                }
                contentStream.write(actual);
            }
            contentStream.close();
        }
        catch (IOException e) {
            Debugger.print(1, "HttpProxy> IOException while reading from proxy", e);
            data = null;
        }
        catch (Exception e) {
            Debugger.print(1, "HttpProxy> Exception while reading from proxy", e);
            data = null;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
                if (os != null) {
                    os.close();
                    os = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (IOException e) {}
        }
        return data;
    }

    private String getRequestHeader(String targetURL) {
        StringBuffer buf = new StringBuffer(512);
        buf.append("GET " + targetURL + " HTTP/1.0\n");
        int portDelPos = targetURL.indexOf(58);
        int firstSlashPos = targetURL.indexOf(47);
        String targetHost = targetURL;
        String targetPort = "80";
        if (portDelPos != -1 && portDelPos < firstSlashPos) {
            targetHost = targetURL.substring(0, portDelPos);
            targetPort = firstSlashPos == -1 ? targetURL.substring(portDelPos + 1) : targetURL.substring(portDelPos + 1, firstSlashPos);
        } else if (firstSlashPos != -1) {
            targetHost = targetURL.substring(0, firstSlashPos);
        }
        buf.append("Host: ");
        buf.append(targetHost);
        buf.append(':');
        buf.append(targetPort);
        buf.append('\n');
        buf.append("Accept: */*\n");
        buf.append("Cache-control: no-transform\n");
        buf.append("Connection: close\n");
        buf.append("User-Agent: MIDP2.0\n");
        buf.append('\n');
        String header = buf.toString();
        buf = null;
        targetHost = null;
        targetPort = null;
        return header;
    }
}

