/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.rms;

import com.cisco.rms.RecordStoreListener;
import com.cisco.rms.SettingsObject;
import com.cisco.util.Debugger;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class RecordStoreWrapper {
    public static void loadSettings(RecordStoreListener callback, String recordStoreName) {
        SettingsLoader sl = new SettingsLoader(callback, recordStoreName);
        Thread thread = new Thread(sl);
        thread.start();
    }

    public static void saveSettings(RecordStoreListener callback, Hashtable source, String recordStoreName) {
        Debugger.print(4, "RecordStoreWrapper> Save settings called.");
        Hashtable temp = new Hashtable();
        Enumeration e = source.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            temp.put(key, source.get(key));
        }
        SettingsSaver ss = new SettingsSaver(callback, temp, recordStoreName);
        Thread thread = new Thread(ss);
        thread.start();
    }

    public static void deleteRecordStore(String recordStoreName) {
        try {
            RecordStore.deleteRecordStore((String)recordStoreName);
        }
        catch (Exception e) {
            Debugger.print(2, "RecordStoreWrapper> No RecordStore to delete");
        }
    }

    private static class SettingsSaver
    implements Runnable {
        private Hashtable source = null;
        private RecordStoreListener callback = null;
        private String recordStoreName = null;

        public SettingsSaver(RecordStoreListener call, Hashtable source, String recordStoreName) {
            this.source = source;
            this.callback = call;
            this.recordStoreName = recordStoreName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RecordStore recordStore = null;
            try {
                RecordStoreWrapper.deleteRecordStore(this.recordStoreName);
                recordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
                Enumeration e = this.source.elements();
                while (e.hasMoreElements()) {
                    SettingsObject obj = (SettingsObject)e.nextElement();
                    byte[] data_in = obj.toByteArray();
                    recordStore.addRecord(data_in, 0, data_in.length);
                    Debugger.print(3, "RecordStoreWrapper> Saving Object:" + obj.getIdentifier());
                }
            }
            catch (Exception e) {
                Debugger.print(1, "RecordStoreWrapper> Error while saving recordStore.", e);
            }
            finally {
                try {
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreException e) {
                    Debugger.print(1, "RecordStoreWrapper> Error closing recordStore during saving.", (Exception)((Object)e));
                }
            }
            this.callback.recordStoreSaved();
        }
    }

    private static class SettingsLoader
    implements Runnable {
        private RecordStoreListener callback = null;
        private String recordStoreName = null;

        public SettingsLoader(RecordStoreListener call, String recordStoreName) {
            this.callback = call;
            this.recordStoreName = recordStoreName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RecordStore recordStore = null;
            Hashtable<String, SettingsObject> destination = new Hashtable<String, SettingsObject>();
            try {
                recordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
                if (recordStore.getNextRecordID() == 1) {
                    Debugger.print(4, "RecordStoreWrapper> Loading default records.");
                    this.callback.loadDefault(destination);
                } else {
                    int nextID = recordStore.getNextRecordID();
                    byte[] data = null;
                    for (int id = 0; id < nextID; ++id) {
                        Debugger.print(4, "RecordStoreWrapper> Loading id: " + id);
                        try {
                            int size = recordStore.getRecordSize(id);
                            if (data == null || data.length < size) {
                                data = new byte[size];
                            }
                            recordStore.getRecord(id, data, 0);
                            SettingsObject obj = this.callback.getSettingsObject(data);
                            Debugger.print(4, "RecordStoreWrapper> Loading Object: " + obj);
                            destination.put(obj.getIdentifier(), obj);
                            continue;
                        }
                        catch (InvalidRecordIDException e) {
                            Debugger.print(4, "RecordStoreWrapper> Unable to find record id: " + id);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (RecordStoreException e) {
                Debugger.print(1, "RecordStoreWrapper> RecordStore failed to load", (Exception)((Object)e));
            }
            finally {
                try {
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreException e) {
                    Debugger.print(1, "RecordStoreWrapper> Error closing recordStore during loading. Could mean RecordStore was not opened.");
                    Debugger.print(1, "RecordStoreWrapper> Error: " + e.getMessage());
                }
            }
            this.callback.recordStoreLoaded(destination);
        }
    }
}

