/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.weather;

import com.cisco.rms.SettingsObject;
import com.cisco.util.Debugger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class City
extends SettingsObject {
    String zip;
    int position;
    boolean isLoaded = false;

    public City(String string, int n) {
        this.zip = string;
        this.position = n;
    }

    public City(byte[] byArray) {
        super(byArray);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        if (n >= 0) {
            this.position = n;
        }
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean bl) {
        this.isLoaded = bl;
    }

    public String getZip() {
        return this.zip;
    }

    public String getIdentifier() {
        return Integer.toString(this.position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(this.getZip());
            dataOutputStream.writeInt(this.getPosition());
        }
        catch (IOException iOException) {
            Debugger.print(1, "City> Unable to write to byte array", iOException);
        }
        finally {
            try {
                dataOutputStream.close();
            }
            catch (Exception exception) {
                Debugger.print(1, "City> Unable to close OutputStream", exception);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromByteArray(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            this.zip = dataInputStream.readUTF();
            this.position = dataInputStream.readInt();
            this.isLoaded = false;
        }
        catch (IOException iOException) {
            Debugger.print(1, "City> Unable to write to byte array", iOException);
        }
        finally {
            try {
                dataInputStream.close();
            }
            catch (Exception exception) {
                Debugger.print(1, "City> Unable to close OutputStream", exception);
            }
        }
    }
}

