/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.weather;

import com.cisco.rms.RecordStoreListener;
import com.cisco.rms.RecordStoreWrapper;
import com.cisco.rms.SettingsObject;
import com.cisco.util.Debugger;
import com.cisco.util.GlobalSettings;
import com.cisco.weather.City;
import com.cisco.weather.LocationRequest;
import com.cisco.weather.SettingsListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

class Settings
implements RecordStoreListener {
    private static final String recordStoreName = "saved-cities";
    private static Settings singleton = null;
    private Hashtable cities = new Hashtable();
    private SettingsListener listener = null;
    static /* synthetic */ Class class$com$cisco$weather$Settings;

    private Settings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Settings getInstance() {
        if (singleton == null) {
            Class clazz = class$com$cisco$weather$Settings == null ? (class$com$cisco$weather$Settings = Settings.class$("com.cisco.weather.Settings")) : class$com$cisco$weather$Settings;
            synchronized (clazz) {
                if (singleton == null) {
                    singleton = new Settings();
                }
            }
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyInstance() {
        if (singleton != null) {
            Class clazz = class$com$cisco$weather$Settings == null ? (class$com$cisco$weather$Settings = Settings.class$("com.cisco.weather.Settings")) : class$com$cisco$weather$Settings;
            synchronized (clazz) {
                if (singleton != null) {
                    singleton = null;
                }
            }
        }
    }

    public int getSize() {
        int n = this.cities.size();
        Debugger.print(4, "Settings> CityList size = " + n);
        return n;
    }

    public String getZipcodeByPosition(int n) {
        City city = (City)this.cities.get(Integer.toString(n));
        if (city == null) {
            throw new NoSuchElementException("Settings> No city at position " + n);
        }
        String string = city.getZip();
        Debugger.print(4, "Settings> Found zip at " + n + " = " + string);
        return string;
    }

    public int getPositionByZipcode(String string) {
        Enumeration enumeration = this.cities.elements();
        while (enumeration.hasMoreElements()) {
            City city = (City)enumeration.nextElement();
            if (!city.getZip().equals(string)) continue;
            return city.getPosition();
        }
        throw new NoSuchElementException("Settings> No city with zipcode " + string);
    }

    public synchronized void removeCityByPosition(int n) {
        Hashtable<String, City> hashtable = new Hashtable<String, City>();
        Enumeration enumeration = this.cities.elements();
        while (enumeration.hasMoreElements()) {
            City city = (City)enumeration.nextElement();
            int n2 = city.getPosition();
            if (n2 < n) {
                Debugger.print(4, "Keeping position for: " + city.getZip() + "@" + n2);
                hashtable.put(Integer.toString(city.getPosition()), city);
                continue;
            }
            if (n2 <= n) continue;
            Debugger.print(4, "Updating Position for: " + city.getZip() + " from: " + n2 + " to: " + (n2 - 1));
            city.setPosition(n2 - 1);
            hashtable.put(Integer.toString(city.getPosition()), city);
        }
        this.cities = hashtable;
    }

    public synchronized void removeCityByZipcode(String string) {
        int n = this.getPositionByZipcode(string);
        this.removeCityByPosition(n);
    }

    public void addCityByZipcode(String string) {
        this.cities.put(Integer.toString(this.getSize()), new City(string, this.getSize()));
    }

    public synchronized void loadSettings(SettingsListener settingsListener) {
        if (settingsListener == null) {
            throw new IllegalArgumentException("Listener cannot be null.");
        }
        this.listener = settingsListener;
        RecordStoreWrapper.loadSettings(this, recordStoreName);
    }

    public synchronized void saveSettings(SettingsListener settingsListener) {
        if (settingsListener == null) {
            throw new IllegalArgumentException("Listener cannot be null.");
        }
        this.listener = settingsListener;
        RecordStoreWrapper.saveSettings(this, this.cities, recordStoreName);
    }

    public void recordStoreLoaded(Hashtable hashtable) {
        this.cities.clear();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.cities.put(k, hashtable.get(k));
        }
        hashtable = null;
        this.listener.settingsLoaded();
    }

    public void recordStoreSaved() {
        this.listener.settingsSaved();
    }

    public void loadDefault(Hashtable hashtable) {
        String string = GlobalSettings.getAppProperty("Default-City");
        if (string == null || string.equals("")) {
            Debugger.print(2, "Service Parameter Not Set - Default-City");
            string = "95134";
        }
        String string2 = null;
        if (string.length() == 5 && Settings.isNumeric(string)) {
            string2 = "Z" + string;
        } else {
            LocationRequest locationRequest = new LocationRequest(null, string);
            string2 = locationRequest.getLocationSync();
        }
        if (string2 != null && !string2.equals("99999")) {
            hashtable.put(Integer.toString(0), new City(string2, 0));
        } else {
            hashtable.put(Integer.toString(0), new City("Z95134", 0));
        }
    }

    public SettingsObject getSettingsObject(byte[] byArray) {
        return new City(byArray);
    }

    public synchronized void clearRecords() {
        this.cities.clear();
        RecordStoreWrapper.deleteRecordStore(recordStoreName);
    }

    private static boolean isNumeric(String string) {
        int n = 0;
        boolean bl = true;
        while (bl && n < string.length()) {
            bl = Character.isDigit(string.charAt(n++));
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

