/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.weather;

import com.cisco.util.Debugger;
import com.cisco.util.ImageLoader;
import com.cisco.util.ImageLoaderListener;
import com.cisco.weather.ActionListener;
import com.cisco.weather.WeatherService;
import java.io.IOException;
import java.util.Date;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class WeatherItem
extends CustomItem
implements ImageLoaderListener {
    private static int VPAD_TOP = 5;
    private static int VPAD_CENTER = 5;
    private static int VPAD_BOTTOM = 7;
    private Display display = null;
    private ActionListener listener = null;
    private int cntW = 0;
    private int cntH = 0;
    private Font mediumFont = null;
    private Font smallFont = null;
    private int backgroundColor;
    private int foregroundColor;
    private int highlightedBackgroundColor;
    private int highlightedForegroundColor;
    private Image weatherIcon = null;
    private boolean highlighted = false;
    private String zipcode = null;
    private int when = 0;
    private boolean showName = true;
    private boolean error = false;
    private long lastPress = 0L;

    public WeatherItem(Display display, ActionListener actionListener, String string, int n, boolean bl, boolean bl2) {
        super(null);
        this.zipcode = string;
        this.when = n;
        this.showName = bl;
        this.display = display;
        this.listener = actionListener;
        this.error = bl2;
        this.mediumFont = Font.getFont((int)0, (int)0, (int)0);
        this.smallFont = Font.getFont((int)0, (int)0, (int)8);
        this.backgroundColor = this.display.getColor(0);
        this.foregroundColor = this.display.getColor(1);
        this.highlightedBackgroundColor = this.display.getColor(2);
        this.highlightedForegroundColor = this.display.getColor(3);
        if (!bl2) {
            try {
                String string2 = WeatherService.getImageName(string, n);
                ImageLoader.getInstance().loadImage(this, string2);
            }
            catch (NullPointerException nullPointerException) {
                Debugger.print(1, "WeatherItem> An error occured while loading the image for " + string, nullPointerException);
            }
        }
        Debugger.print(4, "WeatherItem> Created");
    }

    public WeatherItem(Display display, ActionListener actionListener, String string, boolean bl) {
        this(display, actionListener, string, -1, true, bl);
    }

    protected void paint(Graphics graphics, int n, int n2) {
        this.cntH = n2;
        this.cntW = n;
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, this.cntW, this.cntH);
        if (this.highlighted) {
            try {
                Image image = ImageLoader.getInstance().getImage("selected");
                graphics.drawImage(image, 0, 0, 20);
            }
            catch (IOException iOException) {
                Debugger.print(1, "StockItem> Couldn't load selected image.", iOException);
                graphics.setColor(this.highlightedBackgroundColor);
                graphics.fillRect(0, 0, this.cntW, this.cntH);
            }
        }
        graphics.setColor(193, 202, 206);
        graphics.drawLine(0, this.cntH - 1, this.cntW, this.cntH - 1);
        int n3 = (this.cntW - 50) / 2 + 50;
        int n4 = (this.cntH - 42) / 2;
        if (!this.showName) {
            n3 -= 120;
        }
        int n5 = 12;
        int n6 = 15;
        int n7 = (this.cntH - this.mediumFont.getHeight()) / 2;
        if (!this.error) {
            Debugger.print(3, "WeatherItem> Getting Weather for Zip: " + this.zipcode + " When: " + this.when);
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            try {
                string = WeatherService.getConditions(this.zipcode, this.when);
                string2 = WeatherService.getHigh(this.zipcode, this.when);
                string3 = WeatherService.getLow(this.zipcode, this.when);
                string4 = WeatherService.getCityName(this.zipcode);
                string5 = WeatherService.getDayString(this.zipcode, this.when);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (string4.length() > 22) {
                string4 = string4.substring(0, 20) + "...";
            }
            if (string.length() > 14 && this.showName) {
                string = string.substring(0, 12) + "...";
            }
            if (string.length() > 22 && !this.showName) {
                string = string.substring(0, 20) + "...";
            }
            if (this.weatherIcon != null) {
                graphics.drawImage(this.weatherIcon, n3, n4, 20);
            }
            if (this.highlighted) {
                graphics.setColor(this.highlightedForegroundColor);
            } else {
                graphics.setColor(this.foregroundColor);
            }
            graphics.setFont(this.mediumFont);
            graphics.drawString(string, this.cntW - n6, VPAD_TOP, 24);
            if (this.showName) {
                graphics.drawString(string4, n5, n7, 20);
            } else {
                graphics.drawString(string5, n5, n7, 20);
            }
            graphics.setFont(this.smallFont);
            if (this.when < 0) {
                graphics.drawString("Current: " + string2, this.cntW - n6, this.cntH - VPAD_BOTTOM, 40);
            } else {
                graphics.drawString("High: " + string2 + "  Low: " + string3, this.cntW - n6, this.cntH - VPAD_BOTTOM, 40);
            }
        } else {
            if (this.highlighted) {
                graphics.setColor(this.highlightedForegroundColor);
            } else {
                graphics.setColor(this.foregroundColor);
            }
            graphics.setFont(this.mediumFont);
            if (this.zipcode.startsWith("C")) {
                graphics.drawString("Weather unavailable for city code " + this.zipcode.substring(1), n5, n7, 20);
            } else if (this.zipcode.startsWith("Z")) {
                graphics.drawString("Weather unavailable for zip code " + this.zipcode.substring(1), n5, n7, 20);
            } else {
                graphics.drawString("Weather unavailable", n5, n7, 20);
            }
        }
    }

    public void imageLoaded(Image image) {
        this.weatherIcon = image;
        this.repaint();
    }

    public void update() {
        if (!this.error) {
            ImageLoader.getInstance().loadImage(this, WeatherService.getImageName(this.zipcode, this.when));
        }
        this.repaint();
    }

    protected int getMinContentHeight() {
        int n = this.showName ? VPAD_CENTER : VPAD_CENTER - 2;
        return this.mediumFont.getHeight() + this.smallFont.getHeight() + VPAD_TOP + n + VPAD_BOTTOM;
    }

    protected int getMinContentWidth() {
        return this.display.getCurrent().getWidth();
    }

    protected int getPrefContentHeight(int n) {
        int n2 = this.showName ? VPAD_CENTER : VPAD_CENTER - 2;
        return this.mediumFont.getHeight() + this.smallFont.getHeight() + VPAD_TOP + n2 + VPAD_BOTTOM;
    }

    protected int getPrefContentWidth(int n) {
        return this.display.getCurrent().getWidth();
    }

    protected void pointerPressed(int n, int n2) {
        if (this.showName) {
            this.listener.unHighlightAll();
            this.highlighted = true;
            if (!this.error) {
                long l = new Date().getTime();
                if (l - this.lastPress < 250L) {
                    this.listener.citySelected(this.zipcode);
                    this.lastPress = 0L;
                } else {
                    this.lastPress = l;
                    this.notifyStateChanged();
                    this.repaint();
                }
            }
        }
    }

    protected void pointerReleased(int n, int n2) {
    }

    protected void keyPressed(int n) {
        if (this.getGameAction(n) == 8 && this.showName && !this.error) {
            this.listener.citySelected(this.zipcode);
        }
    }

    protected void sizeChanged(int n, int n2) {
        this.cntH = n2;
        this.cntW = n;
    }

    protected boolean traverse(int n, int n2, int n3, int[] nArray) {
        if (this.showName) {
            this.listener.unHighlightAll();
            this.highlighted = true;
            this.notifyStateChanged();
            this.repaint();
        }
        return false;
    }

    protected void traverseOut() {
        if (this.showName) {
            this.highlighted = false;
            this.notifyStateChanged();
            this.repaint();
        }
    }

    public String getZipcode() {
        return this.zipcode;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }
}

