/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.weather;

import com.cisco.midp.ui.LcduiUtility;
import com.cisco.util.Debugger;
import com.cisco.util.GlobalSettings;
import com.cisco.util.ImageLoader;
import com.cisco.weather.ActionListener;
import com.cisco.weather.LoadingItem;
import com.cisco.weather.Settings;
import com.cisco.weather.SettingsListener;
import com.cisco.weather.WeatherItem;
import com.cisco.weather.WeatherService;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;

public class WeatherMidlet
extends MIDlet
implements CommandListener,
ItemStateListener,
ActionListener,
SettingsListener {
    public static final String appTitle = "Weather Forecast - by WeatherBug\u2122";
    private Display display = null;
    private Form mainForm = null;
    private Form cityForm = null;
    private Form loadingForm = null;
    private List selectionList = null;
    private Command exitCommand = null;
    private Command backCommand = null;
    private Command detailsCommand = null;
    private Command addCommand = null;
    private Command removeCommand = null;
    private Command selectCommand = null;
    private TextField inputField = null;
    private Hashtable cityOptions = null;
    private boolean started = false;
    private boolean paused = false;
    private boolean didFinishLoading = false;
    private boolean searching = false;
    private boolean toledo = false;
    private int loading = 0;
    static /* synthetic */ Class class$com$cisco$weather$WeatherItem;
    static /* synthetic */ Class class$com$cisco$weather$LoadingItem;

    public void startApp() {
        Debugger.getInstance().setDebugLevel(4);
        Debugger.print(3, "WeatherMidlet> Application Starting.");
        if (!this.checkModelIsSupported()) {
            Form form = new Form(appTitle);
            form.setCommandListener((CommandListener)this);
            this.exitCommand = new Command("Exit", 7, 1);
            form.addCommand(this.exitCommand);
            form.append((Item)new StringItem(null, "Phone Model Not Supported. Please Upgrade to a Roundtable Phone."));
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)form);
        } else {
            this.paused = false;
            if (this.started) {
                this.resumeApp();
            } else {
                this.started = true;
                this.initializeApp();
            }
        }
    }

    protected void initializeApp() {
        this.display = Display.getDisplay((MIDlet)this);
        try {
            Class.forName("com.cisco.midp.ui.LcduiUtility");
            this.toledo = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.toledo = false;
        }
        this.loadingForm = new Form(appTitle);
        this.loadingForm.setCommandListener((CommandListener)this);
        this.loadingForm.setTicker(new Ticker("\u0000Weather Loading"));
        Gauge gauge = new Gauge(" ", false, -1, 2);
        this.loadingForm.append((Item)gauge);
        this.display.setCurrent((Displayable)this.loadingForm);
        Debugger.print(4, "WeatherMidlet> Loading Screen Visable");
        this.exitCommand = new Command("Exit", 7, 1);
        this.detailsCommand = new Command("Details", 8, 1);
        this.addCommand = new Command("Add", 1, 1);
        this.removeCommand = new Command("Remove", 8, 1);
        this.selectCommand = new Command("Select", 8, 1);
        this.backCommand = this.toledo ? new Command("", 2, 1) : new Command("Back", 2, 1);
        this.mainForm = new Form(appTitle);
        this.mainForm.addCommand(this.exitCommand);
        this.mainForm.setCommandListener((CommandListener)this);
        this.mainForm.addCommand(this.addCommand);
        this.mainForm.setItemStateListener((ItemStateListener)this);
        this.inputField = new TextField("", "", 45, 0);
        if (this.toledo) {
            LcduiUtility.setProperty((Object)this.addCommand, (String)"Enable", (Object)Boolean.FALSE);
        }
        this.mainForm.append((Item)this.inputField);
        if (this.toledo) {
            LcduiUtility.setProperty((Object)this.mainForm, (String)"CueingArrows", (Object)Boolean.FALSE);
            LcduiUtility.setProperty((Object)this.inputField, (String)"EmptyHint", (Object)"To add, enter \"zip code\" or \"city, state\"");
            this.mainForm.setTicker(null);
        } else {
            this.mainForm.setTicker(new Ticker("\u0000To add, enter \"zip code\" or \"city, state\""));
        }
        this.cityOptions = new Hashtable();
        GlobalSettings.setMidlet(this);
        Settings.getInstance().loadSettings(this);
    }

    protected void resumeApp() {
        Debugger.print(3, "WeatherMidlet> Loading Weather Service");
        this.paused = false;
        if (this.didFinishLoading) {
            this.refresh();
        } else {
            this.settingChanged(true);
        }
    }

    protected void pauseApp() {
        this.paused = true;
        System.gc();
    }

    protected void destroyApp(boolean bl) {
        this.started = false;
        this.paused = false;
        this.didFinishLoading = false;
        if (bl) {
            Debugger.print(2, "WeatherMidlet> Exiting Unconditionally");
            this.finishClosingApp();
        } else {
            Debugger.print(3, "WeatherMidlet> Saving Application Settings");
            Settings.getInstance().saveSettings(this);
        }
    }

    public void finishClosingApp() {
        Debugger.print(3, "WeatherMidlet> Destroying Applicaiton");
        Settings.destroyInstance();
        ImageLoader.destroyImages();
        this.inputField = null;
        this.exitCommand = null;
        this.backCommand = null;
        this.detailsCommand = null;
        this.addCommand = null;
        this.removeCommand = null;
        this.cityForm = null;
        this.mainForm = null;
        this.display = null;
        System.gc();
        Debugger.print(4, "WeatherMidlet> Exit Complete");
        this.notifyDestroyed();
    }

    public void exitMidlet() {
        Debugger.print(3, "WeatherMidlet> Exiting Application by softkey");
        if (this.checkModelIsSupported()) {
            this.loadingForm.setTicker(new Ticker("\u0000Weather Exiting"));
            this.display.setCurrent((Displayable)this.loadingForm);
            this.destroyApp(false);
        } else {
            System.gc();
            this.notifyDestroyed();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            Debugger.print(4, "WeatherMidlet> Exit Key Pressed");
            this.exitMidlet();
        } else if (command == this.detailsCommand) {
            this.switchToDisplay(this.getSelectedZipcode());
        } else if (command == this.backCommand) {
            this.switchToDisplay("main");
        } else if (command == this.addCommand) {
            if (this.mainForm.size() < 6) {
                if (this.inputField.size() != 0 && !this.searching) {
                    Debugger.print(3, "WeatherMidlet> Command - Add " + this.inputField.getString());
                    if (this.toledo) {
                        LcduiUtility.setProperty((Object)this.mainForm, (String)"Icon", (Object)"Resources:AnimatedIcon.Throbber");
                    }
                    if (this.toledo) {
                        LcduiUtility.setProperty((Object)this.addCommand, (String)"Enable", (Object)Boolean.FALSE);
                    }
                    this.searching = true;
                    WeatherService.getLocationId(this.inputField.getString(), this);
                    this.selectionList = null;
                    this.selectionList = new List(appTitle, 3);
                    this.selectionList.setTicker(new Ticker("\u0000Select a City to Add"));
                    this.selectionList.setSelectCommand(this.selectCommand);
                    this.selectionList.addCommand(this.backCommand);
                    this.selectionList.addCommand(this.selectCommand);
                    this.selectionList.setCommandListener((CommandListener)this);
                    this.cityOptions.clear();
                }
            } else {
                Alert alert = new Alert("Error", "A maximum of 5 cities are allowed.", null, AlertType.ERROR);
                GlobalSettings.getDisplay().setCurrent((Displayable)alert);
            }
        } else if (command == this.removeCommand) {
            String string = this.getSelectedZipcode();
            Debugger.print(3, "WeatherMidlet> Command - Delete (" + string + ")");
            if (string != null) {
                int n = this.getIndexOf(string);
                if (n > 0) {
                    this.mainForm.delete(n);
                }
                Settings.getInstance().removeCityByZipcode(string);
                WeatherService.removeCity(string);
                this.inputField.setString("");
                this.settingChanged(true);
            } else {
                Debugger.print(1, "WeatherMidlet> Remove pressed when it should not be visible.");
            }
        } else if (command == this.selectCommand) {
            int n = this.selectionList.getSelectedIndex();
            String string = this.selectionList.getString(n);
            String string2 = (String)this.cityOptions.get(string);
            Debugger.print(4, "WeatherMidlet> Adding city: " + string + ":" + string2 + " @" + n);
            if (WeatherService.isAdded(string2)) {
                Alert alert = new Alert("Error", "Weather for " + string + " has already been added.", null, AlertType.ERROR);
                GlobalSettings.getDisplay().setCurrent(alert, (Displayable)this.mainForm);
            } else {
                Settings.getInstance().addCityByZipcode(string2);
                this.inputField.setString("");
                this.settingChanged(true);
            }
        }
    }

    public void refresh() {
        Debugger.print(3, "WeatherMidlet> Refreshing visable cities.");
        this.loading = Settings.getInstance().getSize();
        if (this.toledo && this.loading > 0) {
            LcduiUtility.setProperty((Object)this.mainForm, (String)"Icon", (Object)"Resources:AnimatedIcon.Throbber");
        }
        WeatherService.loadWeather(this);
    }

    public void settingsLoaded() {
        if (!this.paused) {
            Debugger.print(3, "WeatherMidlet> Loading Weather Service");
            this.switchToDisplay("main");
            this.settingChanged(true);
        }
    }

    public void settingsSaved() {
        this.finishClosingApp();
    }

    public void settingChanged(boolean bl) {
        if (bl) {
            this.didFinishLoading = false;
            this.citiesUpdated();
        }
        this.switchToDisplay("main");
        if (bl) {
            this.refresh();
        }
    }

    public void locationAdded(String string, String string2) {
        Debugger.print(4, "WeatherMidlet> Location Found: " + string + " : " + string2);
        if (this.toledo) {
            LcduiUtility.setProperty((Object)this.mainForm, (String)"Icon", null);
        }
        if (this.toledo) {
            LcduiUtility.setProperty((Object)this.addCommand, (String)"Enable", (Object)Boolean.TRUE);
        }
        this.searching = false;
        if (string2.equals("99999")) {
            Alert alert = new Alert("Error", "Could not find " + string + ".", null, AlertType.ERROR);
            GlobalSettings.getDisplay().setCurrent((Displayable)alert);
            return;
        }
        if (string == null) {
            if (WeatherService.isAdded(string2)) {
                Alert alert = new Alert("Error", "Weather for " + string2 + " has already been added.", null, AlertType.ERROR);
                GlobalSettings.getDisplay().setCurrent(alert, (Displayable)this.mainForm);
            } else {
                Settings.getInstance().addCityByZipcode(string2);
                this.inputField.setString("");
                this.settingChanged(true);
            }
        } else {
            Debugger.print(4, "WeatherMidlet> Location Listed: " + string + " : " + string2);
            this.cityOptions.put(string, string2);
            this.selectionList.append(string, null);
            this.display.setCurrent((Displayable)this.selectionList);
        }
    }

    public void unHighlightAll() {
        for (int i = 0; i < this.mainForm.size(); ++i) {
            Item item = this.mainForm.get(i);
            if (item.getClass() != (class$com$cisco$weather$WeatherItem == null ? WeatherMidlet.class$("com.cisco.weather.WeatherItem") : class$com$cisco$weather$WeatherItem)) continue;
            ((WeatherItem)item).setHighlighted(false);
        }
    }

    public String getSelectedZipcode() {
        for (int i = 0; i < this.mainForm.size(); ++i) {
            Item item = null;
            item = this.mainForm.get(i);
            if (item.getClass() != (class$com$cisco$weather$WeatherItem == null ? WeatherMidlet.class$("com.cisco.weather.WeatherItem") : class$com$cisco$weather$WeatherItem) || !((WeatherItem)item).isHighlighted()) continue;
            return ((WeatherItem)item).getZipcode();
        }
        return null;
    }

    public int getIndexOf(String string) {
        for (int i = 0; i < this.mainForm.size(); ++i) {
            Item item = null;
            item = this.mainForm.get(i);
            if (item.getClass() != (class$com$cisco$weather$WeatherItem == null ? WeatherMidlet.class$("com.cisco.weather.WeatherItem") : class$com$cisco$weather$WeatherItem) || !((WeatherItem)item).getZipcode().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void switchToDisplay(String string) {
        if (string != null) {
            if (string.equals("main")) {
                this.display.setCurrent((Displayable)this.mainForm);
            } else {
                if (this.cityForm == null) {
                    this.cityForm = new Form(appTitle);
                    this.cityForm.addCommand(this.backCommand);
                    this.cityForm.setCommandListener((CommandListener)this);
                } else {
                    this.cityForm.deleteAll();
                }
                try {
                    this.cityForm.setTicker(new Ticker('\u0000' + WeatherService.getCityName(string)));
                }
                catch (Exception exception) {
                    this.cityForm.setTicker(new Ticker("\u0000Five-day Forcast"));
                }
                int n = 0;
                try {
                    n = WeatherService.numDays(string) - 1;
                }
                catch (Exception exception) {
                    n = 5;
                }
                for (int i = 0; i < n; ++i) {
                    WeatherItem weatherItem = new WeatherItem(this.display, this, string, i, false, false);
                    this.cityForm.append((Item)weatherItem);
                }
                this.display.setCurrent((Displayable)this.cityForm);
            }
        }
    }

    public void citiesUpdated() {
        this.mainForm.deleteAll();
        if (this.toledo) {
            LcduiUtility.setProperty((Object)this.mainForm, (String)"CueingArrows", (Object)Boolean.FALSE);
        }
        if (!this.paused) {
            this.mainForm.append((Item)this.inputField);
            this.itemStateChanged((Item)this.inputField);
        }
        for (int i = 0; i < Settings.getInstance().getSize(); ++i) {
            String string = null;
            try {
                string = Settings.getInstance().getZipcodeByPosition(i);
            }
            catch (Exception exception) {
                Debugger.print(1, "WeatherMidlet> Could not load city in position: " + i);
                if (this.paused) continue;
                this.mainForm.append((Item)new StringItem(null, "Unable to load weather for city."));
                continue;
            }
            Debugger.print(3, "WeatherMidlet> Adding City: " + string);
            string = string.startsWith("Z") ? "zip code " + string.substring(1) : "city code " + string.substring(1);
            if (this.paused) continue;
            this.mainForm.append((Item)new LoadingItem("Loading weather for " + string));
        }
        if (!this.paused) {
            this.didFinishLoading = true;
        }
    }

    public synchronized void cityUpdated(String string, boolean bl) {
        --this.loading;
        if (this.loading <= 0 && this.toledo) {
            LcduiUtility.setProperty((Object)this.mainForm, (String)"Icon", null);
        }
        if (this.paused) {
            return;
        }
        int n = 0;
        try {
            n = Settings.getInstance().getPositionByZipcode(string) + 1;
        }
        catch (NoSuchElementException noSuchElementException) {
            Debugger.print(1, "WeatherMidlet> Weather for " + string + " returned but position not found in Settings.", noSuchElementException);
            return;
        }
        Item item = null;
        try {
            item = this.mainForm.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Debugger.print(1, "WeatherMidlet> Failed to get WeatherItem for " + string, indexOutOfBoundsException);
            return;
        }
        if (item.getClass() == (class$com$cisco$weather$LoadingItem == null ? (class$com$cisco$weather$LoadingItem = WeatherMidlet.class$("com.cisco.weather.LoadingItem")) : class$com$cisco$weather$LoadingItem)) {
            WeatherItem weatherItem = null;
            weatherItem = bl ? new WeatherItem(this.display, this, string, false) : new WeatherItem(this.display, this, string, true);
            try {
                this.mainForm.set(n, (Item)weatherItem);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Debugger.print(1, "WeatherMidlet> Failed to set WeatherItem for " + string, indexOutOfBoundsException);
                return;
            }
        } else if (item.getClass() == (class$com$cisco$weather$WeatherItem == null ? (class$com$cisco$weather$WeatherItem = WeatherMidlet.class$("com.cisco.weather.WeatherItem")) : class$com$cisco$weather$WeatherItem)) {
            ((WeatherItem)item).update();
        } else {
            Debugger.print(1, "WeatherMidlet> Item in form is not LoadingItem or WeatherItem.");
        }
        if (this.cityForm != null && ((WeatherItem)this.cityForm.get(0)).getZipcode().equals(string)) {
            for (int i = 0; i < this.cityForm.size(); ++i) {
                ((WeatherItem)this.cityForm.get(i)).update();
            }
        }
        Debugger.print(4, "WeatherMidlet> Appliction Loading Complete for " + string);
        if (this.toledo) {
            LcduiUtility.setProperty((Object)this.mainForm, (String)"CueingArrows", (Object)Boolean.TRUE);
        }
    }

    public void itemStateChanged(Item item) {
        if (item.getClass() != (class$com$cisco$weather$WeatherItem == null ? (class$com$cisco$weather$WeatherItem = WeatherMidlet.class$("com.cisco.weather.WeatherItem")) : class$com$cisco$weather$WeatherItem) || !((WeatherItem)item).isHighlighted()) {
            this.mainForm.removeCommand(this.removeCommand);
            this.mainForm.removeCommand(this.detailsCommand);
            this.mainForm.addCommand(this.addCommand);
            if (this.toledo && !this.searching) {
                if (this.inputField.getString().length() > 0) {
                    LcduiUtility.setProperty((Object)this.addCommand, (String)"Enable", (Object)Boolean.TRUE);
                } else {
                    LcduiUtility.setProperty((Object)this.addCommand, (String)"Enable", (Object)Boolean.FALSE);
                }
            }
        } else {
            this.mainForm.removeCommand(this.addCommand);
            this.mainForm.addCommand(this.removeCommand);
            if (!((WeatherItem)item).isError()) {
                this.mainForm.addCommand(this.detailsCommand);
            }
            Debugger.print(3, ((WeatherItem)item).getZipcode() + " StateChanged = " + ((WeatherItem)item).isHighlighted());
        }
    }

    public void citySelected(String string) {
        this.switchToDisplay(string);
    }

    public boolean checkModelIsSupported() {
        return System.getProperty("microedition.platform").startsWith("CP-99") || System.getProperty("microedition.platform").startsWith("Sun") || System.getProperty("microedition.platform").startsWith("CP-8961");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

