/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.weather;

import com.cisco.util.Debugger;
import com.cisco.weather.ActionListener;
import com.cisco.weather.CityWeather;
import com.cisco.weather.LocationRequest;
import com.cisco.weather.LocationRequestListener;
import com.cisco.weather.Settings;
import com.cisco.weather.WeatherMidlet;
import com.cisco.weather.XMLListener;
import com.cisco.weather.XMLReader;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class WeatherService
implements XMLListener,
LocationRequestListener {
    private static WeatherService singleton = null;
    private ActionListener listener = null;
    private WeatherMidlet callback = null;
    private Hashtable weather = new Hashtable();
    static /* synthetic */ Class class$com$cisco$weather$WeatherService;

    private WeatherService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WeatherService getInstance() {
        if (singleton == null) {
            Class clazz = class$com$cisco$weather$WeatherService == null ? (class$com$cisco$weather$WeatherService = WeatherService.class$("com.cisco.weather.WeatherService")) : class$com$cisco$weather$WeatherService;
            synchronized (clazz) {
                if (singleton == null) {
                    singleton = new WeatherService();
                }
            }
        }
        return singleton;
    }

    public static void loadWeather(ActionListener actionListener) {
        if (actionListener == null) {
            throw new IllegalArgumentException("WeatherService: WeatherListener is null");
        }
        Debugger.print(3, "WeatherService> Loading Weather");
        WeatherService weatherService = WeatherService.getInstance();
        weatherService.listener = actionListener;
        weatherService.downloadWeather();
    }

    private void downloadWeather() {
        Debugger.print(4, "WeatherService> WeatherService running...");
        for (int i = 0; i < Settings.getInstance().getSize(); ++i) {
            XMLReader xMLReader = null;
            String string = "";
            try {
                string = Settings.getInstance().getZipcodeByPosition(i);
            }
            catch (Exception exception) {
                Debugger.print(1, "WeatherService> Could not retrieve feed for " + string);
                Debugger.print(1, "WeatherService> Error looking for zip " + string, exception);
            }
            try {
                Debugger.print(4, "WeatherService> Loading Weather for " + string);
                if (string.startsWith("Z") || string.startsWith("C")) {
                    xMLReader = new XMLReader(this, string);
                    xMLReader.read();
                    continue;
                }
                Debugger.print(1, "WeatherService> Unknown prefix on zip = " + string);
                this.listener.cityUpdated(string, false);
                continue;
            }
            catch (Exception exception) {
                Debugger.print(1, "WeatherService> Error while reading " + string, exception);
                this.listener.cityUpdated(string, false);
            }
        }
    }

    public static void unloadWeather() {
        if (singleton != null) {
            WeatherService.singleton.weather = null;
            singleton = null;
        }
    }

    public static void removeCity(String string) {
        if (singleton == null) {
            return;
        }
        WeatherService.singleton.weather.remove(string);
        Debugger.print(4, "WeatherService> City Removed: " + string);
    }

    private static CityWeather getCityWeather(String string) {
        if (singleton == null) {
            throw new IllegalStateException("Weather not loaded");
        }
        CityWeather cityWeather = (CityWeather)WeatherService.singleton.weather.get(string);
        if (cityWeather == null) {
            throw new NoSuchElementException("Weather for " + string + " not found");
        }
        return cityWeather;
    }

    public static int numDays(String string) {
        CityWeather cityWeather = WeatherService.getCityWeather(string);
        return cityWeather.numDays();
    }

    public static String getConditions(String string, int n) {
        CityWeather cityWeather = WeatherService.getCityWeather(string);
        return cityWeather.getConditions(n);
    }

    public static String getHigh(String string, int n) {
        CityWeather cityWeather = WeatherService.getCityWeather(string);
        return cityWeather.getHigh(n);
    }

    public static String getLow(String string, int n) {
        CityWeather cityWeather = WeatherService.getCityWeather(string);
        return cityWeather.getLow(n);
    }

    public static String getImageName(String string, int n) {
        CityWeather cityWeather = WeatherService.getCityWeather(string);
        return cityWeather.getImageName(n);
    }

    public static String getDayString(String string, int n) {
        CityWeather cityWeather = WeatherService.getCityWeather(string);
        return cityWeather.getDayString(n);
    }

    public static String getCityName(String string) {
        CityWeather cityWeather = WeatherService.getCityWeather(string);
        return cityWeather.getCityName();
    }

    public static boolean isAdded(String string) {
        if (singleton == null) {
            throw new IllegalStateException("WeatherService not loaded");
        }
        return WeatherService.singleton.weather.containsKey(string);
    }

    public void dayParsed(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7) {
        if (string2 == null) {
            Debugger.print(4, "WeatherService> City Not Found: " + string);
            this.listener.cityUpdated(string, false);
        } else {
            CityWeather cityWeather = (CityWeather)WeatherService.singleton.weather.get(string);
            if (cityWeather == null) {
                Debugger.print(4, "WeatherService> City Added: " + string + ", " + string2);
                cityWeather = new CityWeather();
                WeatherService.singleton.weather.put(string, cityWeather);
            }
            Debugger.print(4, "WeatherService> Add Day - Zip: " + string + " Day: " + n + " Condition: " + string3 + " Hi: " + string4 + " Low: " + string5 + " Img: " + string6);
            cityWeather.addDay(n, string3, string4, string5, string6, string7);
            if (n != -1) {
                cityWeather.setCityName(string2);
            }
            if (cityWeather.daySet() && cityWeather.citySet()) {
                Debugger.print(4, "WeatherService> Midlet Notified of city complete");
                this.listener.cityUpdated(string, true);
            }
        }
    }

    public static void getLocationId(String string, WeatherMidlet weatherMidlet) {
        WeatherService weatherService = WeatherService.getInstance();
        weatherService.callback = weatherMidlet;
        if ((string = string.trim()).length() == 5 && WeatherService.isNumeric(string)) {
            weatherService.callback.locationAdded(null, "Z" + string);
        } else if (WeatherService.isNumeric(string.substring(0, 1)) || WeatherService.numbersAndLetters(string)) {
            weatherService.callback.locationAdded(string, "99999");
        } else {
            LocationRequest locationRequest = new LocationRequest(weatherService, string);
            locationRequest.getLocation();
        }
    }

    private static boolean isNumeric(String string) {
        int n = 0;
        boolean bl = true;
        while (bl && n < string.length()) {
            bl = Character.isDigit(string.charAt(n++));
        }
        return bl;
    }

    private static boolean numbersAndLetters(String string) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        while (bl3 && n < string.length()) {
            if (Character.isDigit(string.charAt(n++))) {
                bl = true;
            } else {
                bl2 = true;
            }
            if (!bl2 || !bl) continue;
            bl3 = false;
        }
        return !bl3;
    }

    public void locationFound(String string, String string2) {
        Debugger.print(4, "WeatherService> Location Found: " + string + " : " + string2);
        if (string == null) {
            this.callback.locationAdded(null, string2);
            return;
        }
        if (!string2.equals("99999")) {
            this.callback.locationAdded(string, string2);
        } else {
            Debugger.print(1, "Unable to find " + string + " with '" + string2 + "'");
            this.callback.locationAdded(string, "99999");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

