/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.weather;

import com.cisco.proxy.HttpRequest;
import com.cisco.proxy.HttpRequestListener;
import com.cisco.util.Debugger;
import com.cisco.util.GlobalSettings;
import com.cisco.weather.XMLListener;

class XMLReader
implements HttpRequestListener {
    private String current_url = null;
    private String forecast_url = null;
    private String zipcode = null;
    protected XMLListener listener = null;

    public XMLReader(XMLListener xMLListener, String string) {
        if (xMLListener == null) {
            throw new IllegalArgumentException("XMLReader> XMLListener cannot be null");
        }
        this.listener = xMLListener;
        this.zipcode = string;
        String string2 = "AA10162009";
        this.current_url = "http://api.wxbug.net/getLiveWeatherRSS.aspx?ACode=" + string2;
        this.forecast_url = "http://api.wxbug.net/getForecastRSS.aspx?ACode=" + string2;
        String string3 = null;
        String string4 = GlobalSettings.getAppProperty("Temperature-Units");
        if (string4 == null) {
            Debugger.print(3, "Service Parameter Not Set - Temperature-Units");
            string4 = "F";
        }
        string3 = string4.equalsIgnoreCase("C") || string4.equalsIgnoreCase("Celsius") ? "&UnitType=1" : "&UnitType=0";
        if (string.startsWith("Z")) {
            string3 = string3 + "&Zipcode=" + string.substring(1);
        } else if (string.startsWith("C")) {
            string3 = string3 + "&Citycode=" + string.substring(1);
        } else {
            throw new IllegalStateException("XMLReader> Illegal Prefix on zipcode = " + string);
        }
        this.current_url = this.current_url + string3;
        this.forecast_url = this.forecast_url + string3;
    }

    public void read() throws Exception {
        Debugger.print(3, "Reading url " + this.current_url);
        HttpRequest httpRequest = new HttpRequest(this, this.current_url);
        Thread thread = new Thread(httpRequest);
        thread.start();
        Debugger.print(3, "Reading url " + this.forecast_url);
        HttpRequest httpRequest2 = new HttpRequest(this, this.forecast_url);
        Thread thread2 = new Thread(httpRequest2);
        thread2.start();
    }

    public void httpRequestAction(byte[] byArray, String string) {
        if (byArray == null) {
            this.listener.dayParsed(this.zipcode, null, 0, null, null, null, null, null);
            return;
        }
        String string2 = new String(byArray);
        Debugger.print(3, "HttpResponse Received");
        if (string2 == null || string2.equals("")) {
            this.listener.dayParsed(this.zipcode, null, 0, null, null, null, null, null);
            return;
        }
        if (string2.indexOf("<aws:weather") == -1) {
            this.listener.dayParsed(this.zipcode, null, 0, null, null, null, null, null);
            return;
        }
        if (string.equals(this.current_url)) {
            int n = string2.indexOf("aws:weather");
            String string3 = this.getText(string2, "aws:city-state", n);
            String string4 = this.getText(string2, "aws:current-condition", n);
            String string5 = this.getText(string2, "aws:temp", n);
            String string6 = this.getAttribute(string2, "icon");
            String string7 = "http://img.weather.weatherbug.com/forecast/icons/localized/50x42/en/trans/" + string6.substring(string6.length() - 11, string6.length() - 4) + ".png";
            this.listener.dayParsed(this.zipcode, string3, -1, string4, string5, string5, string7, "Today");
            return;
        }
        if (string.equals(this.forecast_url)) {
            int n = 0;
            boolean bl = false;
            int n2 = string2.indexOf("<aws:forecast>");
            do {
                String string8;
                String string9;
                String string10;
                if ((string10 = this.getText(string2, "aws:location")).equals("")) {
                    this.listener.dayParsed(this.zipcode, null, 0, null, null, null, null, null);
                    return;
                }
                String string11 = this.getText(string10, "aws:city") + ", ";
                String string12 = this.getText(string10, "aws:state");
                if (!string12.equals("")) {
                    string11 = string11 + string12 + " ";
                }
                if (!(string9 = this.getText(string10, "aws:country")).equals("")) {
                    string11 = string11 + string9;
                }
                if ((string8 = this.getText(string2, "aws:forecast", n2)).equals("")) continue;
                n2 += this.getTagLength(string2, "aws:forecast", n2);
                String string13 = this.getText(string8, "aws:high");
                String string14 = this.getText(string8, "aws:low");
                String string15 = this.getText(string8, "aws:image");
                String string16 = "http://img.weather.weatherbug.com/forecast/icons/localized/50x42/en/trans/" + string15.substring(string15.length() - 11, string15.length() - 4) + ".png";
                String string17 = this.getText(string8, "aws:short-prediction");
                String string18 = this.getText(string8, "aws:title");
                this.listener.dayParsed(this.zipcode, string11, n, string17, string13, string14, string16, string18);
                bl = true;
            } while (++n < 5);
            if (bl) {
                return;
            }
        } else {
            this.listener.dayParsed(this.zipcode, null, 0, null, null, null, null, null);
            throw new IllegalStateException("XMLReader> Unrecognized responseUrl");
        }
        this.listener.dayParsed(this.zipcode, null, 0, null, null, null, null, null);
    }

    private String getAttribute(String string, String string2) {
        if (string == null || string2 == null) {
            return "";
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return "";
        }
        int n2 = string.indexOf("\"", n) + 1;
        int n3 = string.indexOf("\"", n2);
        if (n2 < 0 || n3 >= string.length()) {
            return "";
        }
        String string3 = string.substring(n2, n3);
        Debugger.print(4, "Found Attribute: " + string2 + "->" + string3);
        return string3;
    }

    private String getText(String string, String string2) {
        return this.getText(string, string2, 0);
    }

    private int getTagLength(String string, String string2, int n) {
        if (n < 0) {
            n = 0;
        }
        if (string == null || string2 == null) {
            return -1;
        }
        int n2 = string.indexOf("<" + string2 + ">", n);
        if (n2 == -1) {
            n2 = string.indexOf("<" + string2 + " ", n);
        }
        int n3 = string.indexOf("</" + string2 + ">", n);
        if (n2 == -1 || n3 == -1) {
            return -1;
        }
        return n3 - n2 + 3 + string2.length();
    }

    private String getText(String string, String string2, int n) {
        if (n < 0) {
            n = 0;
        }
        if (string == null || string2 == null) {
            return "";
        }
        int n2 = string.indexOf("<" + string2 + ">", n);
        if (n2 == -1) {
            n2 = string.indexOf("<" + string2 + " ", n);
        }
        int n3 = string.indexOf("</" + string2 + ">", n);
        if (n2 == -1 || n3 == -1) {
            return "";
        }
        int n4 = string.indexOf(">", n2) + 1;
        if (n4 < 0 || n3 >= string.length()) {
            return "";
        }
        String string3 = string.substring(n4, n3);
        return string3;
    }
}

