<?
/*

     

  ,    .           .
    !
*/
class File_system {

	public $error = ''; //     .  , :  
	public $fpath = '';
	public $folder = '';
	public $disc_name = '';
	private $type = ''; // folder  file

	function __construct($fpath, $type='file') {
		$this->check_path($fpath);
		$path_info = pathinfo($path);
		$this->folder = $path_info['dirname'];
		$this->fpath = $fpath;
		$this->type = $type;

		//   
		if(preg_match('#^([a-z]):#i', $fpath, $res))
			$this->disc_name = $res[1];
		else
			$this->disc_name = DRIVE_CHAR;
	}

	//  
	function check_path($path) {
		if($this->error) return false;

		$path_info = pathinfo($path);

		if(empty($path_info['folder'])) {
			$this->error = FS_PATH_WRONG . RN . RN . "";
			return false;
		}

		//    
		if($this->type == 'file') {
			if(empty($path_info['dirname'])) {
				$this->error = FS_PATH_WRONG;
				return false;
			}
		}

		return true;
	}

	//  
	function folder_exists() {
		if($this->error) return false;

		if(!file_exists($this->folder)) {
			$this->error = FS_FOLDER_NO_EXISTS;
			return false;
		}
		return true;
	}

	//   
	function folder_writable() {
		if($this->error) return false;

		if(!$this->folder_exists()) return false;

		clearstatcache();

		//   
		if(!is_writable($this->folder)) {
			$this->error = FS_FOLDER_NO_WRITABLE;
			return false;
		}

		return true;
	}

	//  
	function file_exists() {
		if($this->error) return false;

		if(!file_exists($this->fpath)) {
			$this->error = FS_FILE_NO_EXISTS;
			return false;
		}
		return true;
	}

	//   
	function file_writable() {
		if($this->error) return false;

		if(!$this->file_exists()) return false;

		clearstatcache();

		//   
		if(!is_writable($this->fpath)) {
			$this->error = FS_FILE_NO_WRITABLE;
			return false;
		}

		return true;
	}

	//     
	function space_enough($str) {
		if($this->error) return false;

		$disc = new Disc_info();
		$size = $disc->size($this->disc_name, 'KB', 2, false);
		$size_free = $size['free'] + 1; // 1   

		if($size_free < strlen($str)) {
			$this->error = FS_SPACE_NO_ENOUGH;
			return false;
		}
	}

	function file_readable() {
		if($this->error) return false;

		if(!$this->file_exists())
			return false;

		if(!is_readable()) {
			$this->error = FS_FILE_NO_READBLE;
			return false;
		}
	}

	//     
	//        
	function check_save($str) {
		if($this->error) return false;

		if(!$this->folder_writable())
			return false;

		//   
		// ,    
		if(file_exists($path))
			if(!$this->file_writable())
				return false;

		//   
		if($this->space_enough($str))
			return false;
	}

	function check_load() {
		if($this->error) return false;

		//   
		if(!$this->file_readable())
			return false;
	}

	//       
	function save($str) {
		if($this->error) return false;

		if(!$this->check_save($str))
			return false;

		file_put_contents($this->fpath, $str);
	}

	function load() {
		if($this->error) return false;

		if(!$this->check_load())
			return false;

		return file_get_contens($str);
	}

}


?>