<?

//  

class Measure_convert {
	
	//     .     .
	//     max_symbols,        
	//     
	// $short_view = true  2      B
	function pretty_size($size, $measure_input, $short_view = false, $max_symbols=0) {
		$round = 2;

		if(!$size)
			return '0';

		switch($measure_input) {
			case 'BT':
				$sizeBt = $size;
				break;
			case 'KB':
				$sizeBt = $size*1024;
				break;
			case 'MB':
				$sizeBt = $size*1024*1024;
				break;
			case 'GB':
				$sizeBt = $size*1024*1024*1024;
				break;

			default:
				throw new Error_def("  : '$measure_input'");
		}

		$sizeGb = $sizeBt / 1024 / 1024 / 1024;
		$sizeTb = $sizeBt / 1024 / 1024 / 1024 / 1024;

		if($sizeTb >= 0.97) {
			// 
			$output_size = $sizeTb;
			$unit = 'T';
		}
		elseif($sizeGb >= 0.97) { //      1020.
							 //   ,       GB  MB
			// 
			$output_size = $sizeGb;
			$unit = 'G';
		}
		else {
			// 
			$output_size = $sizeBt / 1024 / 1024;
			$unit = 'M';
		}

		//    ,     B
		if(!$short_view) $unit = " {$unit}B";

		$output_size = round_nobug($output_size, $round);

		//   max_symbols
		//  ,    
		if($max_symbols) {
			for($round = $round - 1; $round>=0; $round --) { // 
				if(strlen($output_size) - 1 > $max_symbols) { // -1       
					$output_size = round_nobug($output_size, $round);
				}
				else
					break;
			}
		}

		return $output_size . $unit;
	}

	function block_time_to_speed($time) {
		GLOBAL $OP;
		
		// $log->line($OP['block_size']/1024/$result_time); // 
		// $log->line(round_nobug($OP['block_size']/1024/$result_time), 4);  //   
		// $log->line(round_nobug(0, 4)); //  
		
		if(!$OP['block_size']) throw new Error_def('block_size  ');
		if(!$time) throw new Error_def('  ');
		
		return round_nobug($OP['block_size']/1024/$time, 3);
	}
	
	//   
	function blocks_to_mb($num) {
		GLOBAL $OP, $log;
		
		$mb = round_nobug($num*$OP['block_size']/1024, 2);
		return $mb;
	}

	
	//    , , 
	//     H:i:s
	function format_time($time) {
		GLOBAL $log;
		
		//$log->line($time);
		
		//   
		$time = floor($time);
		
		$hour = floor($time/(60*60));
		//$log->line($hour);
		
		$ostatok = $time - $hour*60*60;
		//$log->line($ostatok);
		
		$minut = floor($ostatok/60);
		//$log->line($minut);
		
		$sec = $ostatok - $minut*60;
		//$log->line($sec);
		
		if(strlen($hour) == 1) $hour = 0 . $hour;
		if(strlen($minut) == 1) $minut = 0 . $minut;
		if(strlen($sec) == 1) $sec = 0 . $sec;
		
		$res =  array('H'=>$hour, 'm'=>$minut, 's'=>$sec);
		
		return "$res[H]:$res[m]:$res[s]";
	}
	
}