<?


//  .     .
abstract class Gr_axis {

	protected $gp; 
	
	public $arrow_x;
	public $arrow_y;
	public $x_title;
	public $y_title;

	function __construct($graph) {
		$this->gp = $graph;

		$this->_load_imgs();
	}


	protected function _load_imgs() {
		GLOBAL $log;

		$fname = './img/graph_arrow_x.gif';
		$this->arrow_x = Btm_and_size($fname, true);

		$fname = './img/graph_arrow_y.gif';
		$this->arrow_y = Btm_and_size($fname, true);

		//  
		//          
		$gp_name = $this->gp->name;
		$this->x_title = Btm_and_size("img/{$gp_name}_x_title.gif", true);
		$this->y_title = Btm_and_size("img/{$gp_name}_y_title.gif", true);
	}

	//    
	public function draw() {
		GLOBAL $log, $Measure_convert;

		$gp = $this->gp;
		$cv = $this->gp->cv;
		
		if($gp->is_enabled) {
			$axis_color = Graph::AXIS_ACTIVE;
			$label_color = Graph::LABEL_COLOR_ACTIVE;
		}else {
			$axis_color = Graph::AXIS_HIDDEN;
			$label_color = Graph::LABEL_COLOR_HIDDEN;
		}
		
		$x = $gp->xZero;
		$y = $gp->yZero;

		$cv->brush->color = Graph::FORM_BG;
		$cv->pen->color = Graph::FORM_BG;
		$cv->font->size = $gp->label_font_size;
		$cv->font->color = $label_color;
		$cv->font->style = '';

		//    
		//  x
		$cv->rectangle($x, $y, $x+700, $y+50);	
		//  y
		$cv->rectangle($x, 300, $x-60, 0);	

		//   gp->keys   , 
		//       keys,      
		//    ,  !
		// STATIC $keys_and_end = false;
		// if(!$keys_and_end) {
		// 	$keys_and_end = $gp->keys;

		// 	if($gp->key_points) {
		// 		$keys_and_end[] = end($gp->key_points);
		// 	}
		// }

		foreach($gp->keys as $sizeMb) {

			$view_label = true;

			if($gp->key_points) {
				$view_label = false;

				if(in_array($sizeMb, $gp->key_points)) {
					$view_label = true;
					//$log->line($gp->key_points[(float)$sizeMb]);
				}
			}

			//$log->line($sizeMb . ' '.  $view_label);

			//print "$x, $y, $name \n";
			
			//    
			$cv->pen->color = $axis_color;
			$cv->rectangle($x, $y, $x+1, $y+2);

			if($view_label) {

				if($sizeMb == 0) {
					$text = '0';
					$x_label = $x - 2;
				}
				else {
					$text = $this->_text_label($sizeMb, $gp->x_measure, $gp->x_measure_view);
					$x_label = $x - 10;
				}

				$cv->textOut($x_label, $y, $text); // 15     

				//  
				$cv->pen->color = $axis_color;
				$cv->rectangle($x, $y+2, $x+2, $y-7);
			}

			$x += $gp->col_width;
		}



		//     
		//   
		//   ,       
		$cv->brush->color = $axis_color;
		$cv->pen->color = $axis_color;	

		// ==  x ==
		// 	
		$x = $gp->xZero;
		$y = $gp->yZero;
		$x2 = $gp->overall_w - $this->arrow_x['w'];
		$cv->rectangle($x, $y, $x2, $y+1);
		
		//  
		$x = $gp->overall_w - $this->arrow_x['w']; 
		$y = $gp->yZero - $this->arrow_x['h'] / 2 + 1;
		$cv->drawBitmap($this->arrow_x['btm'], $x, $y);

		//  
		$x -= $this->x_title['w'];
		$y  = $gp->yZero - $this->x_title['h'];
		$cv->drawBitmap($this->x_title['btm'], $x, $y);


		// ==  y ==
		// 
		$x = $gp->xZero;
		$y = $this->arrow_y['h'];
		$y2 = $gp->yZero;
		$cv->rectangle($x, $y, $x+1, $y2);

		// 
		$x =  $gp->xZero - $this->arrow_y['w'] / 2 + 1;  
		$y =  0;// $gp->arrow_y['height'];
		$cv->drawBitmap($this->arrow_y['btm'], $x, $y);

		//  
		$x = $gp->xZero + $this->arrow_y['w'] / 2; //     
		$y  = 0; //$this->arrow_y['h'];
		$cv->drawBitmap($this->y_title['btm'], $x, $y);


		// ===     y ===
		$label_h = 20; //   ,      
		$label_num = floor($gp->area_data['h'] / $label_h); 
		//$label_num = floor($gp->col_max_height / $label_h); 

		//$log->line();

		if(!$label_num) $label_num = 1;

		$interval_value = $gp->col_max_value / $label_num;
		$interval_px = floor($gp->col_max_height / $label_num);  
		$factor_value_px = $gp->col_max_value / $gp->col_max_height;

		//if($gp->name == 'graph_speed')
		//	$log->line("col_max_height: $gp->col_max_height; area_data[h]: {$gp->area_data['h']}");
		

		$col_max_value = $gp->col_max_value;

		$cv->brush->color = Graph::FORM_BG;

		$x0 = $gp->xZero;
		$y0 = $gp->yZero;

		$y = $y0;
		$label_value = 0;

		for($i = 1; $i<= $label_num; $i++) {
			//   
			$y -= $interval_px;
			$label_value += $interval_value;
			
			//    
			//     
			/*
			if(round_nobug($label_value) != $label_value) {

			}*/

			// 
			$cv->pen->color = $axis_color;
			$cv->pen->style = 'psSolid';
			$cv->rectangle($x0-2, $y, $x0+4, $y-1);

			//    
			$cv->pen->color = $gp->dotted_color;
			$interval = 7;
			$len = 1;
			draw_dotted($cv, $x0, $y-1, $x0 + $gp->area_data['w'], $y-1, $interval, $len);

			//  
			//           

			//  ,        10-20 
			//  ,      
			//  .      
			if($col_max_value > 99)
				$label_value = round_nobug($label_value);

			$text = $this->_text_label($label_value, $gp->y_measure, $gp->y_measure_view);
			$cv->textOut(0, $y-2, $text); // - $gp->label_font_size * $gp->factor_font_size
		}


	}

	protected function _text_label($text, $measure, $measure_view) {
		GLOBAL $Measure_convert;

		$text = $Measure_convert->pretty_size($text, "MB", false);

		//       
		if(!$measure_view) {
			//$log->line($gp->col_name_no_measure);
			if(preg_match('#([\d.]+)#', $text, $res))
				$text = $res[1];
		}

		if($measure  == 'speed')
			$text .= '/s';
		//else $text .= "b";

		return $text;
	}
}
?>