<?

//  .     .
class Gr_singlebar_axis extends Gr_axis {

	protected $gr; 
	
	public $arrow_x;
	public $arrow_y;
	public $x_title;
	public $y_title;

	public $text_axis_bg = 0xfdfdfd;
	protected $fmName = 'Fm';

	function __construct($graph) {
		$this->gr = $graph;
	}

	// 
	public function draw() {
		GLOBAL $log, $Measure_convert;

		$gr = $this->gr;
		$cv = $this->gr->cv;
		
		
		if($gr->is_enabled) {
			$axis_color = Graph::AXIS_ACTIVE;
			$label_color = Graph::LABEL_COLOR_ACTIVE;
		}else {
			$axis_color = Graph::AXIS_HIDDEN;
			$label_color = Graph::LABEL_COLOR_HIDDEN;
		}
		$axis_color = 0xffffff;
		
		$x = $gr->xZero;
		$y = $gr->yZero;

		$cv->brush->color = $this->text_axis_bg;
		$cv->pen->color = $this->text_axis_bg;
		$cv->font->size = $gr->label_font_size;
		$cv->font->color = $label_color;
		$cv->font->style = '';

		//    
		//  x
		$cv->rectangle($x, $y, $x+700, $y+100);	//

		//     x
		$graph_ui = c($this->fmName.'->'.$gr->name);

		$label_num = 5;
		$interval_value = $gr->col_max_value / $label_num;
		$interval_px = floor($graph_ui->w / $label_num);
		$factor_value_px = $gr->col_max_value / $graph_ui->w;

		$x0 = $gr->xZero;
		$y0 = $gr->yZero;

		$x = $x0;
		$label_value = 0;
		for($i = 1; $i< $label_num; $i++) { // <      ,     
			//    
			$x += $interval_px;
			$label_value += $interval_value;

			//   
			$text = $this->_text_label($label_value, $gr->y_measure, $gr->y_measure_view);

			$cv->textOut($x - 10,  $y0, $text);

			//$log->line("label y:  $y0");

			// 
			$cv->pen->color = $axis_color;
			$cv->pen->style = 'psSolid';
			$cv->rectangle($x, $y0, $x+1, $y0-5);
		}

		//   
		//   ,       
		$cv->brush->color = $axis_color;
		$cv->pen->color = $axis_color;	
	}

	protected function _text_label($text, $measure, $measure_view) {
		GLOBAL $Measure_convert;

		$text = $Measure_convert->pretty_size($text, "MB", false, 2);

		//       
		if(!$measure_view) {
			//$log->line($gr->col_name_no_measure);
			if(preg_match('#([\d.]+)#', $text, $res))
				$text = $res[1];
		}

		if($measure  == 'speed') {
			$text .= 'b/s';
		}

		return $text;
	}
}
?>