<?


class Graph_singlebar extends Graph {

	public $active_bg = 0xffffff;//0xbbbbbb;
	public $type = 'singlebar';

	function __construct($name, $keys, $select_bar_name='', $options='') {
		GLOBAL $log;

		parent::__construct($name, $keys, $select_bar_name, $options);

		//       
		$this->adapt_size(false);

		$this->_create_cols();
	}

	//   
	//   
	function adapt_size($new_h=false, $is_redraw=true) {
		$graph = c($this->fmName.'->'.$this->name);
		if($new_h)
			$graph->h = $new_h;

		$h = $graph->h;
		$label_h = 13;

		$this->xZero = 0;
		$this->yZero = $h - $label_h;
		$this->col_width = $h - $label_h; //    .   .       $h - 10 

		//   bitmap
		$this->bitmap->setSizes($graph->w, $graph->h);

		if($is_redraw)
			$this->redraw_all();
	}

	protected function _calc_value_factor() {
		GLOBAL $log;

		$gr_width = c($this->fmName.'->'.$this->name)->w;
		$max_width = $gr_width - $this->xZero;

		$this->value_factor = $max_width / $this->col_max_value;
		//print "calc-" . $this->value_factor;/
	}

	function set_max_value($col_max_value, $is_redraw=true) {
		GLOBAL $log;

		//$log->line('set_max_value' . $col_max_value);

		parent::set_max_value($col_max_value, false);

		$this->calc_coord_size();

		if($is_redraw)
			$this->redraw_all();
	}


	//    
	//        x      
	function calc_coord_size() {
		GLOBAL $log;

		//$log->line('calc_coord_size()');

		$x = $this->xZero;
		foreach($this->cols as $k=>$col) {
			//$log->line($x);

			$col->x = $x;

			//   
			$height = 0;
			if($col->value) {
				$height = $col->value * $this->value_factor;
				if($height < $this->col_min_height) {
					$height = $this->col_min_height;
				}
			}

			$col->height = $height;
			$x += $height;
		}
	}


	private function _create_cols() {
		GLOBAL $log;

		$this->cols = array();

		foreach($this->keys as $nomer=>$name) {
			$color = $this->col_colors[(string)$name];

			$this->cols[(string)$name] = new Gr_singlebar_col($this, 0, $nomer, $name, $color, 0);
		}
	}

}

?>