<?


abstract class Ui_field_type {

	protected $fmName = 'Fm';

	function __construct($field) {
		$this->field = $field;
		$this->check_oncreate();

		$ui = get_ui($this->fmName.'->'.$field->name);

		//   , .      
		if($field->list) {
			$ui->text = implode("\n", $field->list);
		}
	}

	function check_oncreate() {
		if(!get_ui($this->fmName.'->'.$this->field->name))
			throw new Error_def(" {$this->field->name}    ");
	}

	abstract function get($ui);
	abstract function set($ui, $v);
}


class Ui_field_type_text extends Ui_field_type {
	function get($ui) {
		GLOBAL $log;
		//$log->line(__method__ . "({$this->field->name}) " . get_ui($this->field->name)->text);
		//  ui      
		//       get_ui
		//                .
		//       , ui 
		
		return get_ui($this->fmName.'->'.$this->field->name)->text;
		// return $this->field->ui->text;
	}
	function set($ui, $v) {
		GLOBAL $log;

		//$log->line('Ui_field_type_text::set ' . $v);
		//$this->field->ui->text = $v;
		get_ui($this->fmName.'->'.$this->field->name)->text = $v;
		//$log->line("Ui_field_type_text::set check " . $this->field->ui->text);

	}
}

class Ui_field_type_menu extends Ui_field_type  {
	function get($ui) {
		return get_ui($this->fmName.'->'.$this->field->name)->items->selected;
	}
	function set($ui, $v) {
		get_ui($this->fmName.'->'.$this->field->name)->items->selected = $v;
	}
}

class Ui_field_type_combobox extends Ui_field_type  {
	// function __construct($field) {
	// 	parent::__construct($field);

	// 	//           - 
	// 	$ui = get_ui($field->name);
	// 	$ui->text = $ui->text  . "\n ...";
	// }

	function get($ui) {
		$v = get_ui($this->fmName.'->'.$this->field->name)->inText;
		return trim($v); //      
	}
	function set($ui, $v) {
		get_ui($this->fmName.'->'.$this->field->name)->inText = $v;
	}
}

class Ui_field_type_checkbox extends Ui_field_type  {
	function get($ui) {

		$value = get_ui($this->fmName.'->'.$this->field->name)->state;		
		if($value == 'cbChecked') $value = 1;
		else $value = 0;

		return $value;
	}
	function set($ui, $v) {
		if($v == 1) $value = 'cbChecked';
		else $value = 'cbUnchecked';
						
		get_ui($this->fmName.'->'.$this->field->name)->state = $value;
	}
}

class Ui_field_type_speedbutton extends Ui_field_type  {

	//   speedbutton        
	//       _bt1, _bt2 
	function check_oncreate() {
		GLOBAL $log;

		$name = $this->field->name;

		$num_bt = 0;
		for($i=1; $i<=100; $i++) {
			if(!get_ui($this->fmName.'->'."{$name}_bt{$i}")) break;
			$num_bt ++;
		}

		if($num_bt < 2)
			throw new Error_def(" {$name}_bt1 / {$name}_bt2    ");

		$this->field->num_bt = $num_bt;

		// $log->line('- :' . $num_bt);
	}


	function get($ui) {
		//$log->line('get  ' . $bt_name);

		for($i=1; $i<=$this->field->num_bt; $i++)  {
			if(get_ui($this->fmName.'->'.$this->field->name .  "_bt$i")->down)
				return $i;
		}

		return 0;
	}

	function set($ui, $v) {
		GLOBAL $log;

		if(!is_numeric($v))
			throw new Error_def(" v    '$v'");

		$bt_name = $this->field->name .  "_bt$v";
		if(!$bt = get_ui($this->fmName.'->'.$bt_name))
			throw new Error_def("  speedbutton   $bt_name");

		//$log->line('  ' . $bt_name);

		$bt ->down = 1;
	}
}

?>