<?


class Lang_dictionary {

	private $data_mas = array();
	private $lang_folder = 'lang'; //    xml 

	function __construct($lang) {
		$this->lang = $lang;
		$this->data = $this->load($lang);
	}

	function get($name, $error_not_exists=true) {
		if($error_not_exists and !isset($this->data_mas[$name]))
			throw new Error_def("   '$name'    $this->lang");

		return isset($this->data_mas[$name])
				? $this->data_mas[$name]
				: false;
	}

	//  xml 
	function load($lang) {
		$fpath = $this->lang_folder. "/".$lang.'.xml';
		$xml = simplexml_load_file($fpath);
		if(!$xml)
			throw new Error_def("    $fpath");
		
		$this->data_mas = array();
		$const_names = array();
		foreach ($xml as $item){
			//  
			if($item->n) {
				$name = trim((string)$item->n);
			}
			//    
			elseif($item->const) {
				$name = trim((string)$item->const);
				$const_names[] = $name;
			}

			$text = iconv('utf-8', 'windows-1251', (string)$item->v);
			
			//  \t
			$text  = preg_replace("#\t+#", ' ', $text);
			//   
			$text = preg_replace('# {2,}#', ' ', $text);
			//      
			$text = preg_replace("#\n #", "\n", $text);

			$this->data_mas[$name] = trim($text);
		}

		//  
		foreach($this->data_mas as $name=>$text) {
			$this->data_mas[$name] = $this->lookup_processing($text);
		}

		//  
		foreach($this->data_mas as $name=>$text) {
			if(in_array($name, $const_names))
				if(!defined($name)) //   
					define($name, $text);
		}
	}

	//  {_}     
	function lookup_processing($str) {
		
		if(preg_match_all('#{([^}]+)}#', $str, $res)) {
			for($i=0; $i<sizeof($res[1]); $i++) {
				$name = $res[1][$i];
				$value = $this->get($name);

				$str = str_replace('{'.$name.'}', $value, $str);				
			}
		}

		return $str;

		/*        this->data_mas
		$str = preg_replace_callback(
	        	'#{([^}]+)}#',
	       	 function ($matches) {
		        	$name = $matches[1];
		        	$value = $this->data_mas[$name]; //Hint::$data_mas[$name];

		        	if($value) return $value;
		        	else return $matches[0];
		        },
		        $str
		 );
		*/
	}


}

?>