<?

//        x  y,   
class Ui_group {

	private $objArr = array();
	private $formName = ''; //  ,   

	// $check_exists -   
	function __construct(array $objNames, $check_exists=true, $formName='Fm') {

		$this->formName = $formName;

		$this->objArr = array();
		foreach($objNames as $name) {
			if($check_exists and !get_ui($this->formName.'->'.$name))
				throw new Error_def("  ui    '$name'");

			$this->objArr[$name] = array();
		}

		//     
		$this->calc_offset_in_group();
	}

	function visible($visible) {
		foreach($this->objArr as $name=>$info) {
			$obj = c($this->formName.'->'.$name);
			$obj->visible = $visible;
			$obj->enabled = $visible;
		}
	}

	function offset($x = false, $y = false) {
		foreach($this->objArr as $name=>$info) {
			$obj = c($this->formName.'->'.$name);
			
			if($x !== false)
				$obj->x = $obj->x + $x;

			if($y !== false)
				$obj->y = $obj->y + $y;
		}
	}

	//     
	function set_coords($x, $y) {
		foreach($this->objArr as $name=>$info) {
			$obj = c($this->formName.'->'.$name);

			if($x !== false)
				$obj->x = $info['offset_x'] + $x;

			if($y !== false)
				$obj->y = $info['offset_y'] + $y;
		}
	}

	//       
	private function calc_offset_in_group() {
		
		//    
		$coords = array('x'=>array(), 'y'=>array());
		$x0 = 100000;
		$y0 = 100000;
		foreach($this->objArr as $name=>$info) {
			$obj = c($this->formName.'->'.$name);
			$x = $obj->x;
			$y = $obj->y;

			if($x < $x0)
				$x0 = $x;

			if($y < $y0)
				$y0 = $y;
		}

		//print "$x0 $y0";

		//     
		foreach($this->objArr as $name=>$info) {
			$obj = c($this->formName.'->'.$name);
			
			$this->objArr[$name] = array(
				'offset_x' => $obj->x - $x0,
				'offset_y' => $obj->y - $y0,
			);
		}
	}
}

?>