/*
 * Decompiled with CFR 0.152.
 */
package com.moxiu33.treefall;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="treefall", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TreeBreakHandler {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockPos pos;
        Level world = (Level)event.getLevel();
        BlockState state = world.m_8055_(pos = event.getPos());
        if (state.m_60734_() instanceof RotatedPillarBlock) {
            TreeBreakHandler.breakTree(world, pos, new HashSet<BlockPos>());
        }
    }

    private static void breakTree(Level world, BlockPos pos, Set<BlockPos> processed) {
        if (processed.contains(pos)) {
            return;
        }
        processed.add(pos);
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof RotatedPillarBlock || state.m_60734_() instanceof LeavesBlock) {
            world.m_46961_(pos, true);
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        BlockPos newPos = pos.m_7918_(x, y, z);
                        TreeBreakHandler.breakTree(world, newPos, processed);
                    }
                }
            }
        }
    }
}

